﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.ServiceClients.Contracts;

namespace Curse.ServiceClients.TokenGenerator
{
    class Program
    {
        private static string GetPassword()
        {
            var pwd = string.Empty;
            while (true)
            {
                var i = Console.ReadKey(true);
                if (i.Key == ConsoleKey.Enter)
                {
                    break;
                }
                else if (i.Key == ConsoleKey.Backspace)
                {
                    if (pwd.Length > 0)
                    {
                        pwd = pwd.Substring(pwd.Length - 1);
                        Console.Write("\b \b");
                    }
                }
                else
                {
                    pwd = pwd + (i.KeyChar);
                    Console.Write("*");
                }
            }
            return pwd;
        }

        static void Main(string[] args)
        {
            ServicesConfiguration.SetDefaultUrls();

            Console.WriteLine("Username: ");
            var username = Console.ReadLine();

            Console.WriteLine("Password: ");
            var password = GetPassword();

            Console.WriteLine();
            Console.Write("Logging in...");

            // Login
            var resp = Services.Instance.Login.Login(new LoginRequest { Username = username, Password = password });


            if (!resp.Success)
            {
                Console.WriteLine("Login failed: " + resp.Response.StatusMessage);
                Console.ReadKey(true);
                return;
            }

            Console.WriteLine("Success!");
            Console.WriteLine();
            Console.WriteLine("Token: " + resp.Response.Session.Token);
            Console.WriteLine();
            Console.WriteLine("Press enter to exit...");
            Console.ReadLine();
            return;
        }
    }
}
