﻿using System;

namespace Curse.ServiceClients.StatsServiceExample
{
    public static class DateTimeExtensions
    {
        private static readonly DateTime UnixEpoch = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc);

        public static long ToEpochMilliseconds(this DateTime value)
        {
            return (long) (value - UnixEpoch).TotalMilliseconds;
        }

        public static DateTime FromEpochMilliconds(this long value)
        {
            return UnixEpoch.AddMilliseconds(value);
        }
    }
}
