﻿using System;
using System.Linq;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;

namespace Curse.ServiceClients.StatsServiceExample
{
    class Program
    {
        static void Main(string[] args)
        {
            ServicesConfiguration.SetDefaultUrls();

            Console.WriteLine("Enter your authentication token...");
            ServiceAuthentication.Token = Console.ReadLine();

            JsonConvert.DefaultSettings = (() =>
            {
                var settings = new JsonSerializerSettings();
                settings.Converters.Add(new StringEnumConverter());
                return settings;
            });

            var resp = Services.Instance.Stats.GetHostStats(DateTime.UtcNow.AddHours(-1).ToEpochMilliseconds());

            if (resp.Success)
            {
                Console.WriteLine("Success!");
                Console.WriteLine("Response includes " + resp.Response.Length + " stats.");
            }
            else
            {
                Console.WriteLine("Failed: " + resp.StatusCode);
            }

            Console.ReadKey(true);

        }
    }
}
