﻿using System;
using System.IO;
using System.Data;
using System.Configuration;
using System.Web;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Xml;
using Curse;

namespace AddOnService
{
    

    public class AddOnFile
    {
        // Statics
        private static string sMediaFileUrl = ConfigurationManager.AppSettings["MediaFileUrl"];

        public static AddOnFile GetFileById(List<AddOnFile> pFileList, int pFileId)
        {
            foreach (AddOnFile file in pFileList)
            {
                if (file.Id == pFileId)
                {
                    return file;
                }
            }
            return null;
        }
        
        // Privates
        private int mId;
        private string mName;
        private string mTemporaryUrl;
        private string mMediaUrl = null;
        private DateTime mDate;
        private EFileType mType;
        private EFileStatus mStatus = EFileStatus.Normal;
        private bool mIsAvailable = false;
        private bool mIsAlternate = false;
        private int mAlternateFileId = 0;
        private string mChangelog = null;
        private byte[] mChangelogBytes = null;
        private List<long> mFingerprints = new List<long>();
        private Dictionary<string, List<long>> mIndividualFingerprints = new Dictionary<string, List<long>>();
        private List<AddOnFileDependency> mDependencies = new List<AddOnFileDependency>();
        private List<string> mFolderNames = new List<string>();

        // Properties
        public EFileType Type
        {
            get
            {
                return mType;
            }
        }

        public bool IsAvailable
        {
            get
            {
                return mIsAvailable;
            }
        }

        public bool IsAlternate
        {
            get
            {
                return mIsAlternate;
            }
        }

        public long EpochDate
        {
            get
            {
                return Curse.Utility.GetEpochDate(mDate);
            }
        }

        public DateTime Date
        {
            get
            {
                return mDate;
            }
        }

        public String Name
        {
            get
            {
                return mName;
            }
        }        

        public String Changelog
        {
            get
            {
                return mChangelog;
            }
        }

        public int Id
        {
            get
            {
                return mId;
            }
        }

        public EFileStatus Status
        {
            get
            {
                return mStatus;
            }
        }

        public String Url
        {
            get
            {
                if (!String.IsNullOrEmpty(mMediaUrl) && !String.IsNullOrEmpty(sMediaFileUrl))
                {
                    return String.Format(sMediaFileUrl, mMediaUrl);
                }
                else
                {
                    return mTemporaryUrl;
                }
            }
        }

        public List<long> Fingerprints
        {
            get
            {
                return mFingerprints;
            }
            set
            {
                mFingerprints = value;
            }
        }

        public Dictionary<string, List<long>> FolderFingerprints
        {
            get
            {
                return mIndividualFingerprints;
            }
            set
            {                
                mIndividualFingerprints = value;
            }
        }

        public List<string> FolderNames
        {
            get
            {
                return mFolderNames;
            }
        }

        public List<AddOnFileDependency> Dependencies
        {
            get
            {
                return mDependencies;
            }
            set
            {
                mDependencies = value;
            }
        }

        public int AlternateFileId
        {
            get
            {
                return mAlternateFileId;
            }
            set
            {
                mAlternateFileId = value;
            }
        }
      
        public AddOnFile(SqlDataReader pReader, bool pFromArchive)
        {
            mId = pReader.GetInt32(pReader.GetOrdinal("file_id"));
            mName = pReader.GetString(pReader.GetOrdinal("file_name"));            
            mDate = pReader.GetDateTime(pReader.GetOrdinal("file_date"));
            mType = (EFileType)pReader.GetByte(pReader.GetOrdinal("file_type"));
            mIsAlternate = pReader.GetBoolean(pReader.GetOrdinal("file_is_alternate"));            
            mIsAvailable = !pFromArchive;
            mStatus = (EFileStatus)pReader.GetInt32(pReader.GetOrdinal("file_status"));
            if (!pFromArchive)
            {                
                mAlternateFileId = pReader.GetInt32(pReader.GetOrdinal("file_alternate_file_id"));
                mTemporaryUrl = pReader.GetString(pReader.GetOrdinal("file_url"));
                if (pReader["file_media_url"] != System.DBNull.Value)
                {
                    mMediaUrl = pReader.GetString(pReader.GetOrdinal("file_media_url"));
                }
                mChangelog = pReader.GetString(pReader.GetOrdinal("file_change_log"));
                mChangelogBytes = Utility.GetNetworkString(mChangelog);
            }
        }

        public void WriteMatch(BinaryWriter pWriter)
        {
            // File id
            pWriter.Write(Id);
            // Installed Version Name:
            Utility.WriteNetworkString(pWriter, Name);
            // Installed Version Date:
            pWriter.Write(EpochDate);
            // Release Type:
            pWriter.Write((byte)Type);
            // IsAlternate
            pWriter.Write(IsAlternate);
            // Alternate File ID
            pWriter.Write(AlternateFileId);
        }

        public void WriteChangeLogBytes(Stream stream)
        {
            if (mChangelogBytes != null)
            {
                stream.Write(mChangelogBytes, 0, mChangelogBytes.Length);
            }
        }

        public void WriteElement(XmlWriter writer)
        {
            // Begin Element
            writer.WriteStartElement("file");

            // Attributes
            writer.WriteAttributeString("id", mId.ToString());
            writer.WriteAttributeString("type", mType.ToString());
            writer.WriteAttributeString("alternate", mIsAlternate.ToString());
            if (mAlternateFileId > 0)
            {
                writer.WriteAttributeString("alternateFileId", mAlternateFileId.ToString());
            }

            //Name
            writer.WriteStartElement("name");
            writer.WriteValue(mName);
            writer.WriteEndElement();
            //URL
            writer.WriteStartElement("url");
            writer.WriteValue(this.Url);
            writer.WriteEndElement();
            //Date
            writer.WriteStartElement("date");
            writer.WriteValue(mDate);
            writer.WriteEndElement();

            if (Dependencies.Count > 0)
            {
                writer.WriteStartElement("dependencies");
                //Dependencies:
                foreach (AddOnFileDependency dependency in Dependencies)
                {
                    writer.WriteStartElement("dependency");
                    writer.WriteAttributeString("type", ((byte)dependency.Type).ToString());
                    writer.WriteAttributeString("id", dependency.ProjectId.ToString());
                    writer.WriteEndElement();
                }
                writer.WriteEndElement();
            }

            // End Element
            writer.WriteEndElement();
        }
       
    }
}
