﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data.SqlClient;
using System.IO;
using Curse;
namespace AddOnService
{
    public class AddOnFingerprintException
    {
        public int AddOnId
        {
            get;
            set;
        }
        public string FilePath
        {
            get;
            set;
        }
        public AddOnFingerprintException(SqlDataReader pReader)
        {
            AddOnId = pReader.GetInt32(0);
            FilePath = pReader.GetString(1);
        }
        public static byte[] GetSerializedList(List<AddOnFingerprintException> pList)
        {            
            MemoryStream ms = new MemoryStream();
            BinaryWriter bw = new BinaryWriter(ms);
            bw.Write(pList.Count);
            foreach (AddOnFingerprintException exception in pList)
            {
                // Changed to just be the file paths. ID is not needed.
                //bw.Write(exception.AddOnId);
                Utility.WriteNetworkString(bw, exception.FilePath);
            }
            return ms.ToArray();
        }
    }
}
