﻿using System;
using System.Text;

namespace AddOnService
{
    public static class RssDocument
    {
        public static void WriteHeader(StringBuilder pBuilder,
                                       String pFeedTitle,
                                       String pFeedLink,
                                       String pFeedDescription,
                                       String pFeedLocale,
                                       DateTime pFeedDate)
        {
            pBuilder.Append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            pBuilder.Append(Environment.NewLine + "<rss version=\"2.0\">");
            pBuilder.Append(Environment.NewLine + "<channel>");
            pBuilder.AppendFormat(Environment.NewLine + "<title>{0}</title>", pFeedTitle);
            pBuilder.AppendFormat(Environment.NewLine + "<link>{0}</link>", pFeedLink);
            pBuilder.AppendFormat(Environment.NewLine + "<description>{0}</description>", pFeedDescription);
            pBuilder.AppendFormat(Environment.NewLine + "<language>{0}</language>", pFeedLocale);
            pBuilder.AppendFormat(Environment.NewLine + "<lastBuildDate>{0}</lastBuildDate>", pFeedDate.ToString());        
        }

        public static void WriteFooter(StringBuilder pBuilder)
        {
            pBuilder.Append("</channel></rss>");
        }

    }
}
