﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Net;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;
using System.ServiceModel.Web;
using System.Web;


namespace Curse.DownloadStatisticService.Extensions
{
    [AttributeUsage(AttributeTargets.Method)]
    public class RequireApiKeyAttribute : Attribute, IParameterInspector, IOperationBehavior
    {
        private string IncomingApiKeyName { get; set; }
        private string StoredApiKeyName { get; set; }

        public RequireApiKeyAttribute(string incomingApiKeyName, string storedApiKeyName)
        {
            IncomingApiKeyName = incomingApiKeyName;
            StoredApiKeyName = storedApiKeyName;
        }

        #region IParameterInspector Interface Implmentation

        /// <summary>
        /// Implemented from IParameterInspector
        /// </summary>
        /// <param name="operationName"></param>
        /// <param name="outputs"></param>
        /// <param name="returnValue"></param>
        /// <param name="correlationState"></param>
        public void AfterCall(string operationName, object[] outputs, object returnValue, object correlationState) { }

        /// <summary>
        /// Implemented from IParameterInspector
        /// </summary>
        /// <param name="operationName"></param>
        /// <param name="inputs"></param>
        /// <returns>null if validation is successful, WebFaultExption if validation fails</returns>
        public object BeforeCall(string operationName, object[] inputs)
        {
            if (WebOperationContext.Current != null)
            {
                string incomingApiKey = WebOperationContext.Current.IncomingRequest.Headers[IncomingApiKeyName] ?? String.Empty;
            
                string storedApiKey = ServiceModels.Configuration.ServiceConfiguration.Instance.Authentication.ApiAuthentication.ApiKey;

                // Allow any local or LAN connections
                if (HttpContext.Current != null && (HttpContext.Current.Request.IsLocal || HttpContext.Current.Request.UserHostAddress.StartsWith("10.")))
                {
                    return null;
                }

                if (incomingApiKey == storedApiKey)
                {
                    return null; //Sucessful validation, can return
                }
            }

            //else, validation failed, return WebFaultException
            Dictionary<string, int> errorData = new Dictionary<string, int> { { "Invalid API Key", 1001 } };
            throw new WebFaultException<Dictionary<string, int>>(errorData, HttpStatusCode.Forbidden);
        }

        #endregion

        #region IOperationBehavior Interface Implementation

        /// <summary>
        /// Implemented by IOperationBehavior
        /// </summary>
        /// <param name="operationDescription"></param>
        /// <param name="bindingParameters"></param>
        public void AddBindingParameters(OperationDescription operationDescription, System.ServiceModel.Channels.BindingParameterCollection bindingParameters) { }

        /// <summary>
        /// Implemented by IOperationBehavior
        /// </summary>
        /// <param name="operationDescription"></param>
        /// <param name="clientOperation"></param>
        public void ApplyClientBehavior(OperationDescription operationDescription, ClientOperation clientOperation) { }

        /// <summary>
        /// Implemented by IOperationBehavior
        /// </summary>
        /// <param name="operationDescription"></param>
        /// <param name="dispatchOperation"></param>
        public void ApplyDispatchBehavior(OperationDescription operationDescription, DispatchOperation dispatchOperation)
        {
            dispatchOperation.ParameterInspectors.Add(this);
        }

        /// <summary>
        /// Implemented by IOperationBehavior
        /// </summary>
        /// <param name="operationDescription"></param>
        public void Validate(OperationDescription operationDescription) { }

        #endregion
    }
}