﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Runtime.Serialization;
using System.Web;

namespace Curse.DownloadStatisticService.Models
{
    [Serializable]
    [DataContract]
    public class ProjectCount
    {
        [DataMember(Name = "id", Order = 1)]
        public int ProjectID { get; set; }

        [DataMember(Name = "total", Order = 2)]
        public int ProjectCounts { get; set; }

        [DataMember(Name = "lastThirtyDays", Order = 3)]
        public int ProjectCountLast30Days { get; set; }

        public void SetFromDataReader(SqlDataReader reader)
        {
            ProjectID = reader.GetInt32(reader.GetOrdinal("ID"));
            ProjectCounts = reader.GetInt32(reader.GetOrdinal("TotalDownloads"));
            ProjectCountLast30Days = reader.GetInt32(reader.GetOrdinal("DownloadsLastThirtyDays"));
        }
    }
}