﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Runtime.Serialization;
using System.Web;

namespace Curse.DownloadStatisticService.Models
{
    [Serializable]
    [DataContract]
    public class ProjectPopularity
    {
        [DataMember(Name = "id", Order = 1)]
        public int ID { get; set; }

        [DataMember(Name = "score", Order = 2)]
        public decimal Score { get; set; }

        [DataMember(Name = "rank", Order = 3)]
        public int Rank { get; set; }

        [DataMember(Name = "gameRank", Order = 4)]
        public int GameRank { get; set; }


        public void SetFromDataReader(SqlDataReader reader)
        {
            ID = reader.GetInt32(reader.GetOrdinal("ID"));
            Score = reader.GetDecimal(reader.GetOrdinal("PopularityScore"));
            Rank = reader.GetInt32(reader.GetOrdinal("PopularityRank"));
            GameRank = reader.GetInt32(reader.GetOrdinal("GamePopularityRank"));
        }
    }
}