﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.ServiceModels.Caching;
using Curse.DownloadStatisticService.Models;
using System.Configuration;
using Curse.ServiceModels.Configuration;
using Curse.Extensions;
using System.Data.SqlClient;

namespace Curse.DownloadStatisticService.Caching
{
	public class ProjectCache : IncrementalCache<Project>
	{
		private ConcurrentDictionary<int, Project> _currentResults = new ConcurrentDictionary<int, Project>();

		static ProjectCache _instance = new ProjectCache();
		public static ProjectCache Instance { get { return _instance; } }

		public ProjectCache() : base("DownloadStatistics", "spGetProjectData") { }

		public override bool UpdateCache()
		{
			var results = new Dictionary<int, Project>(_currentResults);

			using (var conn = new SqlConnection(DatabaseConfiguration.Instance["DownloadStatistics"].ConnectionString))
			{
				var cmd = new SqlCommand("spGetProjectData", conn);
				cmd.CommandType = System.Data.CommandType.StoredProcedure;
				cmd.Parameters.Add(LastQueryParameter);
				cmd.CommandTimeout = 360;

				conn.Open();
				using (var reader = cmd.ExecuteReader())
				{
					while (reader.Read())
					{
						var project = new Project();
						project.SetFromDataReader(reader);
					    _currentResults.AddOrUpdate(project.ID, project, (key, value) => project);
					}
				}
			}

			return true;
		}

		public bool CheckProjectData(AddDownloadLogEntryMessage message, out string returnMessage)
		{
			if (!_currentResults.ContainsKey(message.ProjectID))
			{
				if (!CreateProject(message))
				{
					returnMessage = "Failed to Create Project record.";
					return false;
				}
			}

			returnMessage = "Success";
			return true;
		}

		private bool CreateProject(AddDownloadLogEntryMessage message)
		{
			using (var conn = new SqlConnection(DatabaseConfiguration.Instance["DownloadStatistics"].ConnectionString))
			{
				var cmd = new SqlCommand("INSERT INTO [Project] (ID, GameID, PopularityScore, PopularityRank, GamePopularityRank, DownloadsLastThirtyDays, UniqueDownloadsLastThirtyDays, TotalDownloads, DateModified) VALUES(@ID, @GameID, 0.0, 0, 0, 0, 0, 0, GETUTCDATE())", conn);
				cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = message.ProjectID;
				cmd.Parameters.Add("GameID", System.Data.SqlDbType.Int).Value = message.GameID;

				try
				{
					conn.Open();
					cmd.ExecuteNonQuery();
				}
				catch (SqlException sqlex)
				{
					if (sqlex.Message.Contains("Violation of PRIMARY KEY constraint"))
					{
						//swallow the exception as the project got inserted but the service cache just doesn't know it yet
					}
					else
					{
						throw new Exception(sqlex.Message, sqlex.InnerException);
					}
				}
				catch (Exception exc)
				{
					Logger.Log("Failed to create Project Record. Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
					return false;
				}

				var project = new Project
				{
					ID = message.ProjectID,
					GameID = message.GameID,
					TotalDownloads = 0,
					PopularityScore = 0.0
				};

                _currentResults.AddOrUpdate(project.ID, project, (key, value) => project);

				return true;
			}
		}

	}
}