﻿using System;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;
using System.Web.Routing;
using System.ServiceModel.Activation;
using Curse.DownloadStatisticService.Caching;

namespace Curse.DownloadStatisticService
{
    public class Global : System.Web.HttpApplication
    {
        protected void Application_Start(object sender, EventArgs e)
        {
            RouteTable.Routes.Add(new ServiceRoute("", new WebServiceHostFactory(), typeof(DownloadStatisticService)));
        }

        protected void Application_End(object sender, EventArgs e)
        {
            Logger.Log("Service is Stopping. Flushing messages to Disk.", ELogLevel.Error, DownloadLogEntryCache.Instance.GetQueueCount() );
            DownloadLogEntryCache.Instance.FlushQueueToDisk();
        }
    }
}