﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.ServiceModels.Caching;
using Curse.Extensions;

namespace Curse.DownloadStatisticService.Models
{
	public class DownloadLogEntry
	{
		#region ICachable Members

		public long ID { get; set; }

		public void SetFromDataReader(System.Data.SqlClient.SqlDataReader reader)
		{
			ID = reader.GetInt64(reader.GetOrdinal("ID"));
			FileID = reader.GetInt32(reader.GetOrdinal("FileID"));
			GameID = reader.GetInt32(reader.GetOrdinal("GameID"));
			ProjectID = reader.GetInt32(reader.GetOrdinal("ProjectID"));
			ReferrerID = reader.GetNullableValue<int>("ReferrerID");
			UserAgentID = reader.GetNullableValue<int>("UserAgentID");
			IpAddress = reader.GetString(reader.GetOrdinal("IPAddress"));
			Date = reader.GetDateTime(reader.GetOrdinal("Date"));
		}

		#endregion

		public int FileID { get; set; }
		public int GameID { get; set; }
		public int ProjectID { get; set; }
		public int ReferrerID { get; set; }
		public int UserAgentID { get; set; }
		public string IpAddress { get; set; }
		public DateTime Date { get; set; }
	}
}