﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.ServiceModels.Caching;
using System.Data.SqlClient;
using Curse.DownloadStatisticService.Caching;
using Curse.Extensions;

namespace Curse.DownloadStatisticService.Models
{
	public class Project : ICachable
	{
		public int ID { get; set; }

		public void SetFromDataReader(SqlDataReader reader)
		{
			ID = reader.GetInt32(reader.GetOrdinal("ID"));
			TotalDownloads = reader.GetInt32(reader.GetOrdinal("TotalDownloads"));
			PopularityScore = reader.GetDouble(reader.GetOrdinal("PopularityScore"));
			GameID = reader.GetInt32(reader.GetOrdinal("GameID"));
		}

		public double PopularityScore { get; set; }
		public int GameID { get; set; }
		public int TotalDownloads { get; set; }

	}
}