﻿using System;
using System.Collections.Generic;
using Curse.Azeroth.Models;
using System.Data;
using System.Data.SqlClient;
using Curse.Extensions;

namespace Curse.Azeroth.DB
{
    public static class DbUtilities
    {
        public static void LoadSchema(ref DataTable schema, string tableName, SqlConnection conn)
        {
            schema = new DataTable();

            if (conn.State != ConnectionState.Open)
            {
                conn.Open();
            }

            SqlCommand cmd = new SqlCommand(string.Format("SELECT TOP 1 * FROM {0} with(nolock)", tableName), conn);
            using (var reader = cmd.ExecuteReader(CommandBehavior.SchemaOnly | CommandBehavior.KeyInfo))
            {
                schema.Load(reader);
            }
        }
    }
}