﻿using System;
using Curse.Azeroth.DB;
using Curse.Azeroth.Models;
using System.Data.SqlClient;
using System.Data;
using System.Configuration;
using System.Collections.Generic;

namespace Curse.Azeroth.DbObjects.Wow
{
    public class QuestDb : DbObject
    {
        public override void Save(IUpdate update, SqlConnection conn)
        {
            if (update is WowUpdate)
            {
                var wowUpdate = update as WowUpdate;
                var bulkCopy = new SqlBulkCopy(conn);

                var questTable = new DataTable();
                var questClassTable = new DataTable();
                var questRaceTable = new DataTable();

                DbUtilities.LoadSchema(ref questTable, "Quest", conn);
                DbUtilities.LoadSchema(ref questClassTable, "QuestClass", conn);
                DbUtilities.LoadSchema(ref questRaceTable, "QuestRace", conn);

                foreach (var quest in wowUpdate.Quests)
                {
                    var row = questTable.NewRow();
                    row["Build"] = wowUpdate.Build;
                    row["QuestID"] = quest.Id;
                    if (quest.BeginningQuestGiver != null)
                    {
                        row["SourceID"] = quest.BeginningQuestGiver.QuestGiverId;
                        row["SourceTypeID"] = quest.BeginningQuestGiver.QuestGiverType;
                    }
                    else if(quest.EndingQuestGiver != null)
                    {
                        row["SourceID"] = quest.EndingQuestGiver.QuestGiverId;
                        row["SourceTypeID"] = quest.EndingQuestGiver.QuestGiverType;
                    }
                    row["QuestBegin"] = (quest.BeginningQuestGiver != null);
                    if(quest.Timer != default(int))
                    {
                        row["Timer"] = quest.Timer;
                    }
                    row["CanShare"] = quest.CanShare;
                    row["CreateDate"] = DateTime.UtcNow;

                    questTable.Rows.Add(row);

                    // Classes
                    var classIds = GetEntityIds(quest.ClassNames, "ChrClasses");
                    foreach (var classId in classIds)
                    {
                        var classRow = questClassTable.NewRow();
                        classRow["Build"] = wowUpdate.Build;
                        classRow["QuestID"] = quest.Id;
                        classRow["ClassID"] = classId;
                        classRow["DateCreated"] = DateTime.UtcNow;

                        questClassTable.Rows.Add(classRow);
                    }

                    // Races
                    var raceIds = GetEntityIds(quest.RaceNames, "ChrRaces");
                    foreach (var raceId in raceIds)
                    {
                        var classRow = questRaceTable.NewRow();
                        classRow["Build"] = wowUpdate.Build;
                        classRow["QuestID"] = quest.Id;
                        classRow["RaceID"] = raceId;
                        classRow["DateCreated"] = DateTime.UtcNow;

                        questRaceTable.Rows.Add(classRow);
                    }
                }

                bulkCopy.DestinationTableName = "Quest";
                bulkCopy.WriteToServer(questTable);

                bulkCopy.DestinationTableName = "QuestClass";
                bulkCopy.WriteToServer(questClassTable);

                bulkCopy.DestinationTableName = "QuestRace";
                bulkCopy.WriteToServer(questRaceTable);
            }
        }

        private List<int> GetEntityIds(List<string> entityNames, string sourceTable)
        {
            var entityIds = new List<int>();
            using (var conn = new SqlConnection(ConfigurationManager.ConnectionStrings["WowService"].ConnectionString))
            {
                var cmd = new SqlCommand(string.Format("SELECT Id FROM {0} WHERE InternalName = @EntityName", sourceTable), conn);
                cmd.Parameters.Add("EntityName", SqlDbType.VarChar);

                conn.Open();
                foreach (string entityName in entityNames)
                {
                    cmd.Parameters["EntityName"].Value = entityName;
                    var raceId = cmd.ExecuteScalar();
                    if (raceId != DBNull.Value)
                    {
                        entityIds.Add((int)raceId);
                    }
                }
            }
            return entityIds;
        }
    }
}