﻿using System;
using Curse.Azeroth.DB;
using Curse.Azeroth.Models;
using System.Data.SqlClient;
using System.Data;
using System.Configuration;

namespace Curse.Azeroth.DbObjects.Wow
{
    public class ZoneDb : DbObject
    {
        public override void Save(IUpdate update, SqlConnection conn)
        {
            if (update is WowUpdate)
            {
                var wowUpdate = update as WowUpdate;
                var bulkCopy = new SqlBulkCopy(conn);

                var fishingLocation = new DataTable();

                DbUtilities.LoadSchema(ref fishingLocation, "Location", conn);

                foreach (var node in wowUpdate.FishingNodes)
                {
                    foreach (var instanceInfo in node.InstanceInfo)
                    {
                        foreach (var location in instanceInfo.Locations)
                        {
                            foreach (var coord in location.Coordinates)
                            {
                                foreach (var drop in coord.Drops)
                                {
                                    var locRow = fishingLocation.NewRow();
                                    locRow["Build"] = wowUpdate.Build;
                                    locRow["EntityTypeID"] = int.Parse(ConfigurationManager.AppSettings["FishingEntityID"]); // Fishing
                                    locRow["EntityID"] = drop.DropId;
                                    locRow["InstanceDifficultyID"] = instanceInfo.InstanceDifficulty;
                                    locRow["ZoneID"] = location.LocationID;
                                    locRow["MapLevel"] = coord.MapLevel;
                                    locRow["X"] = coord.X;
                                    locRow["Y"] = coord.Y;
                                    locRow["DateCreated"] = DateTime.UtcNow;

                                    fishingLocation.Rows.Add(locRow);
                                }
                            }
                        }
                    }
                }

                bulkCopy.DestinationTableName = "Location";
                bulkCopy.WriteToServer(fishingLocation);
            }
        }
    }
}