﻿using System.IO;
using ICSharpCode.SharpZipLib.Zip;

namespace Curse.AzerothService.Extensions
{
    public static class StreamExtensions
    {
        const int _bufferSize = 4096;

        public static void ReadFromWebStream(this MemoryStream memStream, Stream sourceStream)
        {
            int size = 0;
            byte[] buffer = new byte[_bufferSize];
            while ((size = sourceStream.Read(buffer, 0, _bufferSize)) > 0)
            {
                memStream.Write(buffer, 0, size);
            }
            memStream.Position = 0;
        }

        public static MemoryStream Unzip(this MemoryStream memStream)
        {
            int size = 0;

            var inputStream = new ZipInputStream(memStream);
            ZipEntry entry = inputStream.GetNextEntry();
            var uncompressedStream = new MemoryStream();

            byte[] buffer = new byte[_bufferSize];
            while ((size = inputStream.Read(buffer, 0, _bufferSize)) > 0)
            {
                uncompressedStream.Write(buffer, 0, size);
            }
            inputStream.Close();
            uncompressedStream.Position = 0;

            return uncompressedStream;
        }
    }
}