﻿using System;
using System.ServiceModel;
using System.IO;

namespace Curse.AzerothService.Models
{
    [MessageContract]
    public class UploadDbFileMessage : IDisposable
    {
        [MessageHeader(MustUnderstand = true)]
        public int UserID { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public string FileName { get; set; }

        [MessageBodyMember(Order = 1)]
        public Stream FileByteStream { get; set; }

        public void Dispose()
        {
            if (FileByteStream != null)
            {
                FileByteStream.Dispose();
                FileByteStream = null;
            }
        }
    }
}