﻿using System.Linq;
using Curse.ClientService.Managers;
using Curse.ClientService.Models;
using System;
using System.Collections.Concurrent;
using System.Configuration;
using System.Data.SqlClient;
using System.ServiceModel;
using System.Threading;
using Curse.ClientService.Extensions;
using System.ServiceModel.Channels;
using Curse.Extensions;
using System.IO;
using System.Collections.Generic;
using Curse.ServiceAuthentication;
using Newtonsoft.Json;
using Curse.Logging;



namespace Curse.ClientService
{
    [ServiceBehavior(Name = "CClientBugReportingService",
        Namespace = "http://clientservice.curse.com/",
        AddressFilterMode = AddressFilterMode.Any,
        ConcurrencyMode = ConcurrencyMode.Multiple,
        InstanceContextMode = InstanceContextMode.PerSession)]
    public class CClientBugReportingService : IClientBugReportingService
    {
        public BugReportResponse SubmitBugReport(BugReport report)
        {
            return BugReportingManager.Instance.SubmitBugReport(report);            
        }                
    }
}
