﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using Curse.ClientService.Models;
using System.ServiceModel.Activation;
using Curse.ClientService.Extensions;
using Curse.ClientService.GeoCoding;
using Curse.ServiceAuthentication;
using Curse.ServiceAuthentication.Models;

namespace Curse.ClientService
{ 
    [ServiceBehavior(Name = "CClientRegistrationService",
        Namespace = "http://clientservice.curse.com/",
        AddressFilterMode = AddressFilterMode.Any,
        ConcurrencyMode = ConcurrencyMode.Multiple,
        InstanceContextMode = InstanceContextMode.PerCall)]    
    public class CClientRegistrationService : IClientRegistrationService
    {
       
        public bool IsUsernameAvailable(string username)
        {
            return AuthenticationProvider.IsUsernameAvailable(username);            
        }

        public RegisterUserResult RegisterUser(
            string username,
            string password,            
            string email)
        {
            // Geo code their country
            var clientIPAddress = OperationContext.Current.GetClientIPAddress();
            var countryCode = GeoIPHelper.Instance.GetCountryCodeFromIP(clientIPAddress);

            return AuthenticationProvider.RegisterUser(username, password, null, null, null, null, countryCode, null, null, email, false);
        }
        
    }
}
