﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Activation;
using System.Threading;
using System.ServiceModel.Channels;

using Curse.ClientService.Managers;
using Curse.Extensions;
using System.Configuration;
using System.Web;
using Curse.ClientService.Models;
using Curse.ClientService.Extensions;
using System.IO;
using System.ServiceModel.Web;
using System.Text;

//using Curse.ClientService.com.curse.auth;
using System.ServiceModel.Description;
using Curse.ClientService.AdminModels;
using System.Data.SqlClient;
using System.Data;
using Curse.ClientService.GeoCoding;
using Curse.Logging;
using Curse.ServiceAuthentication;
using Curse.ServiceAuthentication.Models;

namespace Curse.ClientService
{
    [ServiceBehavior(Name = "CClientService",
        Namespace = "http://clientservice.curse.com/",
        AddressFilterMode = AddressFilterMode.Any,
        ConcurrencyMode = ConcurrencyMode.Multiple,
        InstanceContextMode = InstanceContextMode.PerSession)]
    public class CClientService : IClientService
    {

        private static object _startLock = new object();

        public void StartServiceBuild()
        {
            // Starts the service, begins feed building.
        }

        static CClientService()
        {

            
        }


       public bool SaveHardwareProfile(HardwareProfile profile)
        {
            try
            {
                return true;
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "SaveUsageProfile - Unhandled Exception!");
                return false;
            }
        }

        public bool SaveUsageProfile(UsageProfile profile)
        {

            var session = AuthenticationProvider.CurrentSession;
            var clientIPAddress = OperationContext.Current.GetClientIPAddress(true);
            
            if (!clientIPAddress.Equals(IPAddress.None))
            {
                profile.CountryCode = GeoIPHelper.Instance.GetCountryCodeFromIP(clientIPAddress, true);
            }

            try
            {
                return UsageReportingCache.SaveReport(session.UserID, profile);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "SaveUsageProfile - Unhandled Exception!");
                return false;
            }
        }
       
        public string HealthCheck()
        {
            using (var conn = new SqlConnection(ConfigurationManager.ConnectionStrings["RoamingDBRadon"].ConnectionString))
            {
                conn.Open();
            }

            return "Success";
        }

#if DEBUG
        public string TestDatababaseReadSpeed()
        {
            string connectiongString = ConfigurationManager.ConnectionStrings["RoamingDBRadon"].ConnectionString;
            DateTime startTime = DateTime.UtcNow;
            int counter = 0;
            using (var conn = new SqlConnection(connectiongString))
            {
                conn.Open();
                var command = conn.CreateCommand();
                command.CommandText = "curseService_GetProjectFileGameVersions";
                command.CommandType = CommandType.StoredProcedure;
                command.Parameters.Add("LastUpdated", SqlDbType.DateTime).Value = new DateTime(1979, 5, 17); ;


                using (SqlDataReader gameVersionReader = command.ExecuteReader())
                {
                    while (gameVersionReader.Read())
                    {
                        ++counter;
                        var fileId = gameVersionReader.GetInt32(gameVersionReader.GetOrdinal("ProjectFileID"));
                        var versionName = gameVersionReader.GetString(gameVersionReader.GetOrdinal("Name"));

                    }
                }
            }
            return "Read " + counter.ToString("###,##0") + " addon file game version mappings in " + (DateTime.UtcNow - startTime).TotalSeconds.ToString("###,##0.00") + " seconds from: " + connectiongString;
        }
#endif

        public IEnumerable<UserGrant> GetUserGrants(string apiKey)
        {
            if (apiKey != ConfigurationManager.AppSettings["ApiKey"])
            {
                return null;
            }
            
            List<UserGrant> grants = new List<UserGrant>();
            string connectionString = ConfigurationManager.ConnectionStrings["ClientService"].ConnectionString;

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                try
                {
                    conn.Open();
                    using (SqlCommand command = conn.CreateCommand())
                    {
                        command.CommandText = "SELECT * FROM [UserGrant]";
                        using (SqlDataReader reader = command.ExecuteReader())
                        {
                            while (reader.Read())
                            {
                                grants.Add(new UserGrant
                                {
                                    CreatedByUserID = reader.GetInt32(reader.GetOrdinal("CreatedByUserID")),
                                    GrantedUserID = reader.GetInt32(reader.GetOrdinal("GrantedUserID")),
                                    DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"))
                                });
                            }
                        }
                    }
                }
                catch
                {
                    return null;
                }
            }
            return grants;
        }

        public UserGrantResponse GetUserGrantsPaged(string apiKey, int pageSize, int pageNumber)
        {
            if (apiKey != ConfigurationManager.AppSettings["ApiKey"])
            {
                return null;
            }

            UserGrantResponse response = new UserGrantResponse();
            List<UserGrant> grants = new List<UserGrant>();
            string connectionString = ConfigurationManager.ConnectionStrings["ClientService"].ConnectionString;

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                try
                {
                    conn.Open();

                    using (SqlCommand command = conn.CreateCommand())
                    {
                        command.CommandText = "SELECT COUNT(0) FROM [UserGrant]";
                        using (SqlDataReader reader = command.ExecuteReader())
                        {
                            if (reader.Read())
                            {
                                int count = reader.GetInt32(0);
                                response.PageCount = (int)Math.Ceiling((double)count / pageSize);
                            }
                        }
                    }

                    using (SqlCommand command = conn.CreateCommand())
                    {
                        int skipCount = pageSize * (pageNumber - 1);
                        int takeCount = pageSize;
                        command.CommandText = "SELECT * FROM [UserGrant] ORDER BY [DateCreated] DESC OFFSET {0} ROWS FETCH NEXT {1} ROWS ONLY".FormatWith(skipCount, takeCount);
                        using (SqlDataReader reader = command.ExecuteReader())
                        {
                            while (reader.Read())
                            {
                                grants.Add(new UserGrant
                                {
                                    CreatedByUserID = reader.GetInt32(reader.GetOrdinal("CreatedByUserID")),
                                    GrantedUserID = reader.GetInt32(reader.GetOrdinal("GrantedUserID")),
                                    DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"))
                                });
                            }
                        }
                        response.UserGrants = grants;
                    }
                }
                catch
                {
                    return null;
                }
            }
            return response;
        }

        public UserGrantStatus AddUserGrant(string apiKey, int createdByUserID, int grantedUserID, DateTime dateCreated)
        {
            if (apiKey != ConfigurationManager.AppSettings["ApiKey"])
            {
                return UserGrantStatus.InvalidApiKey;
            }

            string connectionString = ConfigurationManager.ConnectionStrings["ClientService"].ConnectionString;

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                try
                {
                    conn.Open();
                    using (SqlCommand command = conn.CreateCommand())
                    {
                        command.CommandText = "INSERT INTO [UserGrant] ([CreatedByUserID], [GrantedUserID], [DateCreated]) VALUES (@createdByUserID, @grantedUserID, @dateCreated)";
                        command.Parameters.Add(new SqlParameter("@createdByUserID", createdByUserID));
                        command.Parameters.Add(new SqlParameter("@grantedUserID", grantedUserID));
                        command.Parameters.Add(new SqlParameter("@dateCreated", dateCreated));
                        command.ExecuteNonQuery();
                    }
                }
                catch
                {
                    return UserGrantStatus.Failed;
                }
            }

            return UserGrantStatus.Success;
        }

        public GameKeyResult GetOrClaimGameKey(int campaignID)
        {
            try
            {
                var session = AuthenticationProvider.CurrentSession;
                var clientIPAddress = OperationContext.Current.GetClientIPAddress();
                var countryCode = GeoIPHelper.Instance.GetCountryCodeFromIP(clientIPAddress, true) ?? "US";
                return GameKeyCampaignManager.GetOrClaimGameKey(campaignID, session.UserID, countryCode);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "[GetOrClaimGameKey] Unhandled Exception!");
                return new GameKeyResult { Status = GameKeyResultStatus.Error };
            }
        }
    }
}
