﻿using System;
using System.ServiceModel;
using Curse.ClientService.Extensions;
using Curse.ClientService.GeoCoding;
using Curse.Extensions;
using Curse.Logging;
using Curse.ServiceAuthentication;
using Curse.ServiceAuthentication.Models;

namespace Curse.ClientService
{    
    [ServiceBehavior(Namespace = "http://clientservice.curse.com/", AddressFilterMode = AddressFilterMode.Any, ConcurrencyMode = ConcurrencyMode.Multiple, InstanceContextMode = InstanceContextMode.PerCall)]
    public class ClientLoginService : IClientLoginService
    {
        public LoginResponse Login(LoginRequest loginRequest)
        {            
            try
            {

                if (loginRequest.EncryptedPassword.IsNullOrEmpty() && loginRequest.Password.IsNullOrEmpty())
                {
                    return new LoginResponse { Status = AuthenticationStatus.InvalidPassword };
                }

                if (loginRequest.Username.IsNullOrEmpty())
                {
                    return new LoginResponse { Status = AuthenticationStatus.UnknownUsername };
                }

                AuthenticationSession session = null;
                AuthenticationStatus status;
                if (loginRequest.Password != null)
                {
                    status = AuthenticationProvider.TryAuthenticateUser(loginRequest.Username, false, loginRequest.Password, false, out session); 
                }
                else
                {
                    status = AuthenticationProvider.TryAuthenticateUser(loginRequest.Username, true, loginRequest.EncryptedPassword, false, out session); 
                }
                               
                return new LoginResponse { Status = status, Session = session };                
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Error during login!");
                return new LoginResponse { Status = AuthenticationStatus.UnknownError };
            } 
        }

        public RegisterUserResult Register(RegisterRequest request)
        {
            var clientIPAddress = OperationContext.Current.GetClientIPAddress();
            var countryCode = GeoIPHelper.Instance.GetCountryCodeFromIP(clientIPAddress);
            try
            {
                return AuthenticationProvider.RegisterUser(request.Username, request.Password, null, null, null, null, countryCode, null, null, request.Email, request.NewsletterOptIn);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Error during registration!");
                return new RegisterUserResult { Status = RegisterUserStatus.UnknownError };
            }
            
        }

        public bool CheckUsernameAvailability(CheckUsernameAvailabilityRequest request)
        {
            try
            {
                return AuthenticationProvider.IsUsernameAvailable(request.Username);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Error during checking username availability!");
                return false;
            }
        }
    }
}


