﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using Curse.ClientService.Extensions;
using Curse.ClientService.GeoCoding;
using Curse.ClientService.Managers;
using Curse.ClientService.Models;
using Curse.Logging;
using Curse.ServiceAuthentication;
using Newtonsoft.Json;

namespace Curse.ClientService
{
    // NOTE: You can use the "Rename" command on the "Refactor" menu to change the class name "ClientReportingService" in code, svc and config file together.
    // NOTE: In order to launch WCF Test Client for testing this service, please select ClientReportingService.svc or ClientReportingService.svc.cs at the Solution Explorer and start debugging.
    public class ClientReportingService : IClientReportingService
    {
        public BugReportResponse SubmitBugReportJson(BugReportRequest request)
        {
            try
            {
                var report = JsonConvert.DeserializeObject<BugReport>(request.BugReportJson);
                return BugReportingManager.Instance.SubmitBugReport(report);
            }
            catch (Exception ex)
            {
                Logger.Warn(ex, "Failed to process json bug report");
                return new BugReportResponse()
                {
                    Status = BugReportStatus.Error
                };
            }
        }

        public bool SaveUsageProfile(UsageProfile profile)
        {

            var session = AuthenticationProvider.CurrentSession;
            var clientIPAddress = OperationContext.Current.GetClientIPAddress(true);

            if (!clientIPAddress.Equals(IPAddress.None))
            {
                profile.CountryCode = GeoIPHelper.Instance.GetCountryCodeFromIP(clientIPAddress, true);
            }

            try
            {
                return UsageReportingCache.SaveReport(session.UserID, profile);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "SaveUsageProfile - Unhandled Exception!");
                return false;
            }
        }
    }
}
