﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using Curse.ClientService.Managers;
using Curse.ClientService.Models;
using Curse.Logging;
using Curse.ServiceAuthentication;

namespace Curse.ClientService
{
    // NOTE: You can use the "Rename" command on the "Refactor" menu to change the class name "CClientUserReportingService" in code, svc and config file together.
    // NOTE: In order to launch WCF Test Client for testing this service, please select CClientUserReportingService.svc or CClientUserReportingService.svc.cs at the Solution Explorer and start debugging.
    [ServiceBehavior(Name = "ClientUserReportingService", Namespace = "http://clientservice.curse.com/",
        AddressFilterMode = AddressFilterMode.Any,
        ConcurrencyMode = ConcurrencyMode.Multiple,
        InstanceContextMode = InstanceContextMode.PerSession)]
    public class ClientUserReportingService : IClientUserReportingService
    {
        public UserAbuseReportResponse ReportUserAbuse(UserAbuseReportRequest request)
        {
            try
            {
                if (string.IsNullOrEmpty(request.ReportDescription) || request.ReportDescription.Length > 86400)
                {
                    return new UserAbuseReportResponse {Status = UserAbuseReportRequestStatus.Invalid};
                }

                return new UserAbuseReportResponse
                {
                    Status = UserAbuseReportingManager.ReportUserAbuse(AuthenticationContext.Current.AuthenticationSession.UserID,
                        AuthenticationContext.Current.AuthenticationSession.Username,
                        request.ReportingUserPlatform,
                        request.ReportedUserID,
                        request.Reason,
                        request.ReportDescription)
                };
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to report user abuse.");
                return new UserAbuseReportResponse {Status = UserAbuseReportRequestStatus.Error};
            }
        }
    }
}
