﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.SqlClient;
using System.Diagnostics;
using Curse.AddOns;
using Curse.Extensions;
using System.Configuration;

namespace Curse.ClientService.Extensions
{
    public static class CAddOnFileExtension
    {
        private static readonly string sMediaFileUrl = null;
        private static readonly string sCurseForgeFileUrl = null;

        static CAddOnFileExtension()
        {
            sMediaFileUrl = ConfigurationManager.AppSettings["MediaFileUrl"];
            sCurseForgeFileUrl = ConfigurationManager.AppSettings["CurseForgeFileUrl"];
        }

        public static void SetFromDataReader(this CAddOnFile file, SqlDataReader pReader, Dictionary<int, List<CAddOnFileDependency>> dependencies, Dictionary<int, List<string>> gameVersions)
        {
            file.Id = pReader.GetInt32(pReader.GetOrdinal("file_id"));
            file.FileName = pReader.GetString(pReader.GetOrdinal("file_name"));
            file.FileDate = pReader.GetDateTime(pReader.GetOrdinal("file_date"));
            file.ReleaseType = (EFileType)pReader.GetByte(pReader.GetOrdinal("file_type"));
            file.IsAlternate = pReader.GetBoolean(pReader.GetOrdinal("file_is_alternate"));
            file.FileStatus = (EFileStatus)pReader.GetByte(pReader.GetOrdinal("file_status"));
            file.PackageFingerprint = pReader.GetNullableValue<long>("file_package_fingerprint");
            file.IsAvailable = ((file.FileStatus == EFileStatus.Normal) || (file.FileStatus == EFileStatus.ClientOnly && file.IsAlternate == true));

            if (dependencies.ContainsKey(file.Id))
            {
                file.Dependencies = dependencies[file.Id];
            }

            file.AlternateFileId = pReader.GetInt32(pReader.GetOrdinal("file_alternate_file_id"));
            file.DownloadURL = sMediaFileUrl.FormatWith(file.Id.ToModPath(), pReader["file_filename"]);
            file.Changelog = pReader.GetString(pReader.GetOrdinal("file_change_log"));

            if (gameVersions.ContainsKey(file.Id))
            {
                file.GameVersion = gameVersions[file.Id];
            }
        }

        public static string GetChangeLog(this CAddOnFile file)
        {
            if (!string.IsNullOrEmpty(file.Changelog))
                return file.Changelog;

            if (CFileCache.Instance.ChangeLogs.ContainsKey(file.Id))
                return CFileCache.Instance.ChangeLogs[file.Id];

            using (var conn = new SqlConnection(ConfigurationManager.ConnectionStrings["RoamingDBRadon"].ConnectionString))
            {
                using (var cmd = new SqlCommand("select IsNull(ProjectFile.ChangeLog, '') from ProjectFile where ID = @id", conn))
                {
                    cmd.Parameters.Add("id", System.Data.SqlDbType.Int).Value = file.Id;

                    try
                    {
                        conn.Open();
                        file.Changelog = (string)cmd.ExecuteScalar();
                        CFileCache.Instance.ChangeLogs.Add(file.Id, file.Changelog);
                    }
                    catch (Exception exc)
                    {
                        Logger.Log("Failed to pull changelog for file ID: {0} Details: {1}", ELogLevel.Error, file.Id, exc.GetExceptionDetails());
                    }
                }
            }

            return file.Changelog;
        }
    }
}
