﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.SqlClient;
using System.Net;
using System.Diagnostics;
using Curse.Extensions;

namespace Curse.ClientService.GeoCoding
{

    public class CountryIPRange
    {
        public Int64 Start { get; set; }
        public Int64 End { get; set; }
        public string CountryCode { get; set; }

        private static Dictionary<Int64, CountryIPRange> _values;
        private static Int64[] _binarySearchIndex;

        public CountryIPRange(SqlDataReader reader)
        {
            CountryCode = (string)reader["CountryCode"];
            Start = (Int64)reader["IPRangeStart"];
            End = (Int64)reader["IPRangeEnd"];
        }


        public static void BuildRanges(IEnumerable<CountryIPRange> ranges)
        {
            var dict = new Dictionary<Int64, CountryIPRange>();

            foreach (var item in ranges)
            {
                dict[item.Start] = item;
            }


            var searchIndex = dict.Keys.ToArray();

            Array.Sort(searchIndex);

            _values = dict;
            _binarySearchIndex = searchIndex;
        }

        public static CountryIPRange GetRange(IPAddress value)
        {
            return GetRange(value.ToInt64());
        }

        public static CountryIPRange GetRange(Int64 value)
        {
            // Ranges not build yet
            if (_binarySearchIndex == null) 
            {
                return null;
            }

            var searchIndex = Array.BinarySearch(_binarySearchIndex, value);

            if (searchIndex < 0)
                searchIndex = ~searchIndex - 1;

            if (searchIndex < 0)
                return null;

            var proposedRange = _values[_binarySearchIndex[searchIndex]];                        

            if (proposedRange.End >= value)
            {
                return proposedRange;
            }
            
            return null;
            
        }
    }
}
