﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data.SqlClient;
using System.Linq;
using System.Net;
using System.Web;
using Curse.Logging;

namespace Curse.ClientService.GeoCoding
{
    public class GeoIPHelper
    {
        private readonly string _databaseConnectionString;
        private static readonly GeoIPHelper _instance = new GeoIPHelper();

        public GeoIPHelper()
        {
            _databaseConnectionString = ConfigurationManager.ConnectionStrings["ClientService"].ConnectionString;
        }

        public static GeoIPHelper Instance
        {
            get
            {
                return _instance;
            }
        }

        public void Initialize()
        {
            PopulateGeoData();
            IPDatabaseUpdater.Initialize();
        }

        public string GetCountryCodeFromIP(IPAddress ipAddress, bool returnNull = false)
        {
            var range = CountryIPRange.GetRange(ipAddress);

            if (range == null)
            {
                return returnNull ? null : "00"; // Unknown
            }

            return range.CountryCode;
        }

        public void PopulateGeoData()
        {
            var countryIPRanges = new List<CountryIPRange>();
           
            using (var conn = new SqlConnection(_databaseConnectionString))
            {
                try
                {
                    conn.Open();
                }
                catch (Exception exc)
                {
                    Logger.Error(exc, "Unable to establish connection to database", _databaseConnectionString);
                    return;
                }

                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "select * from CountryIpRange order by CountryCode";

                    using (var reader = command.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            countryIPRanges.Add(new CountryIPRange(reader));
                        }
                    }

                    CountryIPRange.BuildRanges(countryIPRanges);
                }
                
            }                        
        }
    }
}