﻿using System.Diagnostics;
using Curse.ClientService.GeoCoding;
using Curse.CloudFlare;
using Curse.CloudFront;
using Curse.Logging;
using Curse.ServiceAuthentication;
using System;
using System.Configuration;
using System.IO;
using Curse.ClientService.Managers;
using Curse.ServiceEncryption;
using Curse.Logging.Uploader;

namespace Curse.ClientService
{
    public class Global : System.Web.HttpApplication
    {
        
        protected void Application_Start(object sender, EventArgs e)
        {
            
            var sw = Stopwatch.StartNew();

            try
            {
                Logger.Init(ConfigurationManager.AppSettings["LogPath"], "RadiumService");
                Logger.Info("Client Service Starting...");
                LogUploader.Initialize(9, ConfigurationManager.AppSettings["LogServiceUrl"], ConfigurationManager.AppSettings["LogServiceApiKey"]);   
                
                var userBackupDirectory = ConfigurationManager.AppSettings["UserBackupsPath"];


                Logger.Info("Checking user backup directory at: " + userBackupDirectory);
                if (!Directory.Exists(userBackupDirectory))
                {
                    Directory.CreateDirectory(userBackupDirectory);
                    Logger.Info("Creating User Backup Directory...");
                }
                    
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "File IO could not be established!");                 
            }

            try
            {
                Logger.Info("Initializing Usage Reporting...");
                UsageReportingCache.Initialize();

                Logger.Info("Initializing IP Database Updater...");
                GeoIPHelper.Instance.Initialize();

                LogDelegate logDelegate = (message, exception, obj) =>
                {
                    if (exception == null)
                    {
                        Logger.Info(message, obj);
                    }
                    else
                    {
                        Logger.Error(exception, message, obj);
                    }
                };

                EncryptionToken.Initialize(ConfigurationManager.AppSettings["EncryptionTokenKey"], int.Parse(ConfigurationManager.AppSettings["EncryptionTokenIterations"]));

                Logger.Info("Initializing Authentication Provider...");

                AuthenticationProvider.Initialize(
                    ConfigurationManager.AppSettings["AuthenticationUrl"],
                    logDelegate, 
                    int.Parse(ConfigurationManager.AppSettings["AuthenticationId"]),
                    ConfigurationManager.AppSettings["AuthenticationKey"],
                    ConfigurationManager.AppSettings["ApiKey"], 
                    false, 
                    false,
                    ConfigurationManager.ConnectionStrings["ClientService"].ConnectionString);

                UserAbuseReportingManager.Initialize();
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Could not start Client Service!");
                throw;
            }


            Logger.Info("Services Started in " + sw.ElapsedMilliseconds + " milliseconds");
        }

        protected void Session_Start(object sender, EventArgs e)
        {

        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {
            System.Web.HttpContext.Current.Response.AddHeader("Access-Control-Allow-Origin", "*");

            if (System.Web.HttpContext.Current.Request.HttpMethod == "OPTIONS")
            {
                //These headers are handling the "pre-flight" OPTIONS call sent by the browser
                System.Web.HttpContext.Current.Response.AddHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
                System.Web.HttpContext.Current.Response.AddHeader("Access-Control-Allow-Headers", "Content-Type, Accept");
                System.Web.HttpContext.Current.Response.AddHeader("Access-Control-Max-Age", "1728000");
                System.Web.HttpContext.Current.Response.End();
            }

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {

        }

        protected void Session_End(object sender, EventArgs e)
        {

        }

        protected void Application_End(object sender, EventArgs e)
        {            
            Logger.Info("Service Stopping");
            LogUploader.Shutdown();            
        }
    }
}