﻿using System.Net.Security;
using System.ServiceModel;
using System.ServiceModel.Web;
using Curse.ServiceAuthentication.Models;

namespace Curse.ClientService
{
    [ServiceContract(Namespace = "http://clientservice.curse.com/", ProtectionLevel = ProtectionLevel.None)]
    public interface IClientLoginService
    {
        [OperationContract]
        [WebInvoke]
        LoginResponse Login(LoginRequest loginRequest);

        [OperationContract]
        [WebInvoke]
        RegisterUserResult Register(RegisterRequest registerRequest);

        [OperationContract]
        [WebInvoke]
        bool CheckUsernameAvailability(CheckUsernameAvailabilityRequest username);
    }
}
