﻿using System;
using System.Collections.Generic;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Net.Security;
using Curse.ClientService.Models;
using Curse.ServiceAuthentication;

namespace Curse.ClientService
{
    [ServiceContract(Name = "CClientService", Namespace = "http://clientservice.curse.com/", ProtectionLevel=ProtectionLevel.None)]
    public interface IClientService
    {

        #region Usage Reporting       

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        bool SaveHardwareProfile(HardwareProfile profile);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/SaveUsageProfile", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        bool SaveUsageProfile(UsageProfile profile);
       
        #endregion       

        #region Control Panel API

        [OperationContract]
        [WebInvoke(UriTemplate = "/StartServiceBuild", Method = "GET")]
        void StartServiceBuild();

        [OperationContract]
        [WebInvoke(UriTemplate = "/GetUserGrants")]
        IEnumerable<UserGrant> GetUserGrants(string apiKey);

        [OperationContract]
        [WebInvoke(UriTemplate = "/GetUserGrantsPaged", BodyStyle = WebMessageBodyStyle.Wrapped)]
        UserGrantResponse GetUserGrantsPaged(string apiKey, int pageSize, int pageNumber);

        [OperationContract]
        [WebInvoke(UriTemplate = "/AddUserGrant", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        UserGrantStatus AddUserGrant(string apiKey, int createdByUserID, int grantedUserID, DateTime dateCreated);

        #endregion

        #region Tests

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        [WebInvoke(UriTemplate = "/HealthCheck", Method = "GET")]
        string HealthCheck();

#if DEBUG
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        [WebInvoke(UriTemplate = "/TestDatabaseReadSpeed", Method = "GET")]
        string TestDatababaseReadSpeed();
#endif

        #endregion

        #region Game Key Campaigns

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        [WebInvoke(UriTemplate = "/GetOrClaimGameKey", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        GameKeyResult GetOrClaimGameKey(int campaignID);

        #endregion

    }
}
