﻿using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using Curse.ClientService.Models;

namespace Curse.ClientService.Managers
{
    public static class GameKeyCampaignManager
    {
        private static readonly string ConnectionString;

        static GameKeyCampaignManager()
        {
            ConnectionString = ConfigurationManager.ConnectionStrings["GameKeyCampaigns"].ConnectionString;
        }

        public static GameKeyResult GetOrClaimGameKey(int campaignID, int userID, string countryCode)
        {
            using (var conn = new SqlConnection(ConnectionString))
            {
                conn.Open();

                using (var cmd = conn.CreateCommand())
                {
                    cmd.CommandType = CommandType.StoredProcedure;
                    cmd.CommandText = "GetOrClaimGameKey";
                    cmd.Parameters.AddWithValue("@CampaignID", campaignID);
                    cmd.Parameters.AddWithValue("@UserID", userID);
                    cmd.Parameters.AddWithValue("@CountryCode", countryCode);

                    var code = cmd.ExecuteScalar();
                    if (code != System.DBNull.Value)
                    {
                        return new GameKeyResult {Key = (string) code, Status = GameKeyResultStatus.Successful };
                    }
                    else
                    {
                        return new GameKeyResult { Status = GameKeyResultStatus.CampaignEnded };
                    }
                }

            }
            
        }

    }
}