﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;
using System.Data.SqlClient;
using System.Runtime.Serialization;

namespace Curse.ClientService.AddOns
{
    [DataContract]
    public class CAddOnFile
    {// Statics
        private static string sMediaFileUrl = ConfigurationManager.AppSettings["MediaFileUrl"];

        public static CAddOnFile GetFileById(List<CAddOnFile> pFileList, int pFileId)
        {
            foreach (CAddOnFile file in pFileList)
            {
                if (file.Id == pFileId)
                {
                    return file;
                }
            }
            return null;
        }
        
        // Privates
        [DataMember]
        public int Id;
       
        [DataMember]
        public string FileName;

        [DataMember]
        public DateTime FileDate;

        [DataMember]
        public EFileType FileType;

        [DataMember]
        public EFileStatus FileStatus = EFileStatus.Normal;

        [DataMember]
        public string DownloadURL;
              

        [DataMember]
        public bool IsAlternate = false;

        [DataMember]
        public int AlternateFileId = 0;

        private bool mIsAvailable = false;                
        private string mChangelog = null;
        private byte[] mChangelogBytes = null;
        private List<long> mFingerprints = new List<long>();
        private Dictionary<string, List<long>> mIndividualFingerprints = new Dictionary<string, List<long>>();
        private List<CAddOnFileDependency> mDependencies = new List<CAddOnFileDependency>();
        private List<string> mFolderNames = new List<string>();
          

        public String Changelog
        {
            get
            {
                return mChangelog;
            }
        }      
               
        public List<long> Fingerprints
        {
            get
            {
                return mFingerprints;
            }
            set
            {
                mFingerprints = value;
            }
        }

        public Dictionary<string, List<long>> FolderFingerprints
        {
            get
            {
                return mIndividualFingerprints;
            }
            set
            {                
                mIndividualFingerprints = value;
            }
        }

        public List<string> FolderNames
        {
            get
            {
                return mFolderNames;
            }
        }

        public List<CAddOnFileDependency> Dependencies
        {
            get
            {
                return mDependencies;
            }
            set
            {
                mDependencies = value;
            }
        }
             
        public CAddOnFile(SqlDataReader pReader, bool pFromArchive)
        {
            Id = pReader.GetInt32(pReader.GetOrdinal("file_id"));
            FileName = pReader.GetString(pReader.GetOrdinal("file_name"));            
            FileDate = pReader.GetDateTime(pReader.GetOrdinal("file_date"));
            FileType = (EFileType)pReader.GetByte(pReader.GetOrdinal("file_type"));
            IsAlternate = pReader.GetBoolean(pReader.GetOrdinal("file_is_alternate"));            
            mIsAvailable = !pFromArchive;
            FileStatus = (EFileStatus)pReader.GetInt32(pReader.GetOrdinal("file_status"));
            if (!pFromArchive)
            {                
                AlternateFileId = pReader.GetInt32(pReader.GetOrdinal("file_alternate_file_id"));
                

                if (pReader["file_media_url"] != System.DBNull.Value)
                {
                    DownloadURL = string.Format(sMediaFileUrl, pReader.GetString(pReader.GetOrdinal("file_media_url")));
                }
                else
                {
                    DownloadURL = pReader.GetString(pReader.GetOrdinal("file_url"));
                }

                mChangelog = pReader.GetString(pReader.GetOrdinal("file_change_log"));
                mChangelogBytes = Utility.GetNetworkString(mChangelog);
            }
        }               
    }
}
