﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.ClientService.AddOns
{
    public class CFingerprintCache
    {
        // Keyed by Fingerprint
        private static Dictionary<long, List<CFingerprintMatch>> sFingerprints = new Dictionary<long, List<CFingerprintMatch>>();
        // Keyed by Folder Name (lowercase)
        private static Dictionary<string, List<CFuzzyMatch>> sFolderFingerprints = new Dictionary<string, List<CFuzzyMatch>>();

        public static void Rebuild(Dictionary<int, CAddOn> pAddOnCache)
        {
            Dictionary<long, List<CFingerprintMatch>> fingerprints = new Dictionary<long, List<CFingerprintMatch>>();
            Dictionary<string, List<CFuzzyMatch>> folderFingerprints = new Dictionary<string, List<CFuzzyMatch>>();
            CAddOn addon = null;
            CAddOnFile file = null;
            string foldername = null;

            foreach (KeyValuePair<int, CAddOn> addonEntry in pAddOnCache)
            {
                addon = addonEntry.Value;
                if (addon.IncludeInIndex)
                {
                    foreach (KeyValuePair<int, CAddOnFile> fileEntry in addon.Files)
                    {
                        file = fileEntry.Value;

                        // Complete Fingerprints
                        foreach (long fingerprint in file.Fingerprints)
                        {
                            if (!fingerprints.ContainsKey(fingerprint))
                            {
                                fingerprints.Add(fingerprint, new List<CFingerprintMatch>());
                            }
                            CFingerprintMatch match = new CFingerprintMatch(addon, file);
                            fingerprints[fingerprint].Add(match);
                        }

                        // Individual Fingerprints                  
                        foreach (KeyValuePair<string, List<long>> folder in file.FolderFingerprints)
                        {
                            foldername = folder.Key;
                            if (!folderFingerprints.ContainsKey(foldername))
                            {
                                folderFingerprints.Add(foldername, new List<CFuzzyMatch>());
                            }
                            folderFingerprints[foldername].Add(new CFuzzyMatch(foldername, addon, file));
                        }
                    }
                }
            }

            lock (sFingerprints)
            {
                sFingerprints = fingerprints;
            }
            lock (sFolderFingerprints)
            {
                sFolderFingerprints = folderFingerprints;
            }
        }


        //public static AddOnFuzzyMatchResult GetFuzzyMatches(string pFolderName, long[] pIndividualFileFingerprints)
        //{
        //    AddOnFuzzyMatchResult result = new AddOnFuzzyMatchResult(pFolderName, pIndividualFileFingerprints);
        //    FindFuzzyMatches(result);
        //    return result;
        //}


        //public static void FindFuzzyMatches(AddOnFuzzyMatchResult pResult)
        //{
        //    List<long> processedFingerprints = new List<long>();
        //    List<CFuzzyMatch> potentialMatches = null;
        //    CFuzzyMatch actualMatch = null;
        //    int matchCount = 0;
        //    int potentialMatchCount = 0;


        //    if (!sFolderFingerprints.ContainsKey(pResult.FolderName))
        //    {
        //        return;
        //    }

        //    int lastId = 0;
        //    bool singleAddonMatch = true;
        //    potentialMatches = sFolderFingerprints[pResult.FolderName];
        //    foreach (CFuzzyMatch potentialMatch in potentialMatches)
        //    {
        //        if (lastId > 0 && lastId != potentialMatch.Id)
        //        {
        //            singleAddonMatch = false;
        //        }
        //        lastId = potentialMatch.Id;
        //        if (potentialMatch.Fingerprints.Count != pResult.Fingerprints.Count)
        //        {
        //            continue;
        //        }
        //        potentialMatchCount = potentialMatch.FuzzyMatchCount(pResult.Fingerprints);

        //        if (potentialMatchCount > matchCount)
        //        {
        //            actualMatch = potentialMatch;
        //            matchCount = potentialMatchCount;
        //            if (potentialMatchCount == pResult.Fingerprints.Count)
        //            {
        //                break;
        //            }
        //        }
        //    }

        //    if (actualMatch == null && singleAddonMatch)
        //    {
        //        actualMatch = sFolderFingerprints[pResult.FolderName][0];
        //    }


        //    pResult.Match = actualMatch;
        //}


        public static CFingerprintMatchResult GetMatches(long[] pFileFingerprints)
        {
            CFingerprintMatchResult result = new CFingerprintMatchResult(pFileFingerprints);
            FindExactMatches(result);
            if (result.ExactFingerprints.Count < result.InstalledFingerprints.Count)
            {
                FindPartialMatches(result);
            }

            return result;
        }

        public static void FindExactMatches(CFingerprintMatchResult pResult)
        {
            List<long> processedFingerprints = new List<long>();
            List<CFingerprintMatch> matches = new List<CFingerprintMatch>();

            foreach (long installedFingerprint in pResult.InstalledFingerprints)
            {
                if (processedFingerprints.Contains(installedFingerprint))
                {
                    continue;
                }
                if (!sFingerprints.ContainsKey(installedFingerprint))
                {
                    continue;
                }
                List<CFingerprintMatch> potentialMatches = sFingerprints[installedFingerprint];

                int matchedCount = 0;
                CFingerprintMatch currentMatch = null;

                foreach (CFingerprintMatch potentialMatch in potentialMatches)
                {
                    // Match must be perfect, and consume more files, be the latest matching release date.
                    if (potentialMatch.IsExactMatch(pResult.InstalledFingerprints) && IsBetterMatch(currentMatch, potentialMatch))
                    {
                        matchedCount = potentialMatch.Fingerprints.Count;
                        currentMatch = potentialMatch;
                    }
                }

                if (currentMatch != null)
                {
                    processedFingerprints.AddRange(currentMatch.Fingerprints);
                    matches.Add(currentMatch);
                }
            }

            pResult.ExactMatches = matches;
            pResult.ExactFingerprints = processedFingerprints;
        }

        public static void FindPartialMatches(CFingerprintMatchResult pResult)
        {
            List<long> processedFingerprints = new List<long>();
            List<CFingerprintMatch> matches = new List<CFingerprintMatch>();
            Dictionary<int, List<long>> matchFingerprints = new Dictionary<int, List<long>>();
            List<long> partialMatchFingerprints = null;

            foreach (long installedFingerprint in pResult.UnmatchedFingerprints)
            {
                if (processedFingerprints.Contains(installedFingerprint))
                {
                    continue;
                }
                if (!sFingerprints.ContainsKey(installedFingerprint))
                {
                    continue;
                }
                List<CFingerprintMatch> potentialMatches = sFingerprints[installedFingerprint];

                int matchedCount = 0;
                int potentialMatchCount = 0;
                CFingerprintMatch currentMatch = null;

                foreach (CFingerprintMatch potentialMatch in potentialMatches)
                {
                    partialMatchFingerprints = potentialMatch.GetPartialMatchFingerprints(pResult.InstalledFingerprints);

                    if (IsBetterMatch(currentMatch, potentialMatch))
                    {
                        currentMatch = potentialMatch;
                        matchedCount = potentialMatchCount;
                    }
                }

                if (currentMatch != null)
                {
                    processedFingerprints.AddRange(currentMatch.Fingerprints);
                    matchFingerprints[currentMatch.Id] = currentMatch.GetPartialMatchFingerprints(pResult.InstalledFingerprints);
                    matches.Add(currentMatch);
                }
            }
            pResult.PartialMatchFingerprints = matchFingerprints;
            pResult.PartialMatches = matches;
        }

        public static bool IsBetterMatch(CFingerprintMatch pCurrentMatch, CFingerprintMatch pPotentialMatch)
        {
            // If there is no current match, then it is always better.
            if (pCurrentMatch == null)
            {
                return true;
            }

            // If this potential match consumes less fingerprints, then it isn't a better match
            if (pPotentialMatch.Fingerprints.Count < pCurrentMatch.Fingerprints.Count)
            {
                return false;
            }

            // if the potential match isn't normal status, and the current one is, discard it.
            if (pPotentialMatch.FileStatus != EFileStatus.Normal && pCurrentMatch.FileStatus == EFileStatus.Normal)
            {
                return false;
            }

            // If this is an earlier release, discard it.
            if (pPotentialMatch.InstalledVersionDate < pCurrentMatch.InstalledVersionDate)
            {
                return false;
            }

            return true;
        }


    }



}
