﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;

namespace Curse.ClientService.AddOns
{
    [DataContract]
    public class CFingerprintMatch
    {
        private CAddOn mAddon = null;
        private CAddOnFile mAddonFile = null;

        public int Id
        {
            get
            {
                return mAddon.Id;
            }
            
        }

        public string InstalledVersionName
        {
            get
            {
                return mAddonFile.FileName;
            }
        }

        public DateTime InstalledVersionDate
        {
            get
            {
                return mAddonFile.FileDate;
            }
        }
       

        public List<long> Fingerprints
        {
            get
            {
                return mAddonFile.Fingerprints;
            }
        }
        
        public List<string> FolderNames
        {
            get
            {
                return mAddonFile.FolderNames;
            }
        }

        public EFileType ReleaseType
        {
            get
            {
                return mAddonFile.FileType;
            }
         
        }        

        public bool IsAlternate
        {
            get
            {
                return mAddonFile.IsAlternate;
            }
        }

        public EFileStatus FileStatus
        {
            get
            {
                return mAddonFile.FileStatus;
            }
        }

     
        public CFingerprintMatch(CAddOn pAddOn, CAddOnFile pFile)         
        {
            mAddon = pAddOn;
            mAddonFile = pFile;            
        }

        public bool IsExactMatch(List<long> pFingerprints)
        {
            foreach (long fingerprint in Fingerprints)
            {
                if (!pFingerprints.Contains(fingerprint))
                {
                    return false;
                }
            }
            return true;
        }

        public List<long> GetPartialMatchFingerprints(List<long> pFingerprints)
        {
            List<long> partialMatches = new List<long>();
            foreach (long fingerprint in Fingerprints)
            {
                if (pFingerprints.Contains(fingerprint))
                {
                    partialMatches.Add(fingerprint);
                }
            }
            return partialMatches;
        }              
    }
}
