﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.ClientService.AddOns
{
    public class CFingerprintMatchResult
    {
        // Privates
        private List<long> mInstalledFingerprints = null;


        // Properties
        public List<CFingerprintMatch> ExactMatches
        {
            get;
            set;
        }

        public List<long> ExactFingerprints
        {
            get;
            set;
        }

        public List<CFingerprintMatch> PartialMatches
        {
            get;
            set;
        }
        
        public Dictionary<int, List<long>> PartialMatchFingerprints
        {
            get;
            set;
        }
        
        public List<long> InstalledFingerprints
        {
            get
            {
                return mInstalledFingerprints;
            }
        }

        private bool IsUnmatched(long s)
        {
            return !ExactFingerprints.Contains(s);
        }


        public List<long> UnmatchedFingerprints
        {
            get
            {                
                return InstalledFingerprints.FindAll(IsUnmatched);             
            }
        }
        
        // Constructor
        public CFingerprintMatchResult()
        {

        }

        public CFingerprintMatchResult(long[] pFingerprints)
        {
            mInstalledFingerprints = new List<long>(pFingerprints);
            ExactMatches = new List<CFingerprintMatch>();
            PartialMatches = new List<CFingerprintMatch>();
        }
    }
}
