﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Activation;
using System.Threading;
using System.ServiceModel.Channels;

using Curse.AddOns;
using Curse.Extensions;
using System.Configuration;
using System.Web;
using Curse.ClientService.Models;
using Curse.ClientService.Extensions;
using System.IO;
using System.ServiceModel.Web;
using System.Text;
using System.Net.Security;
using Curse.ClientService.AdminModels;

namespace Curse.ClientService
{
    [ServiceBehavior(Name="CClientAdminService",
        Namespace="http://clientservice.curse.com/",
        AddressFilterMode=AddressFilterMode.Any,
        ConcurrencyMode = ConcurrencyMode.Multiple,
        InstanceContextMode = InstanceContextMode.PerSession)]
    public class CClientAdminService : IClientAdminService
    {
        

        public List<ClientServiceSession> GetSessionList(TimeSpan activeSince)
        {            
            DateTime minDate = DateTime.UtcNow.Subtract(activeSince);
            List<CSession> sessions = CClientAuthentication.GetAllSessions().Where(p => p.DateLastActive >= minDate).ToList();
            return sessions.ConvertAll<ClientServiceSession>(p => new ClientServiceSession(p));
        }
        


    }
}
