﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using Curse.ClientService.Models;
using System.IO;
using System.ServiceModel.Activation;
using Curse.Extensions;

namespace Curse.ClientService
{
    [ServiceBehavior(Name = "CClientBackupService",
        Namespace = "http://clientservice.curse.com/",
        AddressFilterMode = AddressFilterMode.Any,
        ConcurrencyMode = ConcurrencyMode.Multiple)]
    public class CClientBackupService : IClientBackupService
    {
        #region UserBackups
        public void SaveUserBackup(CUserBackupMessage request)
        {
            CSession session = CClientAuthentication.CurrentSession;

            try
            {
                using (Stream sourceStream = request.FileByteStream)
                {
                    CSyncCache.Instance.SaveUserBackup(session.UserID, request.InstanceID, request.Fingerprint, request.ScreenWidth, request.ScreenHeight, sourceStream);
                    sourceStream.Close();
                }
            }
            catch (IOException exc)
            {
                if (exc.InnerException != null && exc.InnerException.InnerException is System.Xml.XmlException)
                {
                    Logger.Log("SaveUserBackup - XmlException Reading Steam! Details: {0}", ELogLevel.Debug, exc.GetExceptionDetails());
                }
                else
                {
                    throw;
                }
            }
            catch (Exception ex)
            {
                Logger.Log("SaveUserBackup - Unhandled Exception! Details: {0}", ELogLevel.Error, ex.GetExceptionDetails());
            }
        }
        #endregion

        #region Saved Game Sync
        public void SyncSavedGame(CSavedGameSyncMessage request)
        {
            var session = CClientAuthentication.CurrentSession;

            try
            {
                var restriction = CSavedGameSyncCache.Instance.RestrictionLevel;
                switch (restriction)
                {
                    case ESavedGameRestrictionLevel.Disabled:
                        return;
                    case ESavedGameRestrictionLevel.PremiumOnly:
                        if (!session.EffectivePremiumStatus)
                        {
                            return;
                        }
                        break;
                }

                using (var sourceStream = request.FileByteStream)
                {
                    CSavedGameSyncCache.Instance.SyncSavedGame(session.UserID, request.GameID, request.FileName, request.ComputerName, request.Fingerprint, request.DateModified, sourceStream, session.EffectivePremiumStatus);
                }
            }
            catch (IOException exc)
            {
                if (exc.InnerException != null && exc.InnerException.InnerException is System.Xml.XmlException)
                {
                    Logger.Log("SyncSavedGame - XmlException Reading Steam! Details: {0}", ELogLevel.Debug, exc.GetExceptionDetails());
                }
                else
                {
                    throw;
                }
            }
            catch (Exception exc)
            {
                Logger.Log("SyncSavedGame - Unhandled Exception! Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
            }
        }

        public void AddRevision(CSavedGameSyncMessage request)
        {
            var session = CClientAuthentication.CurrentSession;

            try
            {
                var restriction = CSavedGameSyncCache.Instance.RestrictionLevel;
                switch (restriction)
                {
                    case ESavedGameRestrictionLevel.Disabled:
                        return;
                    case ESavedGameRestrictionLevel.PremiumOnly:
                        if (!session.EffectivePremiumStatus)
                        {
                            return;
                        }
                        break;
                }

                using (var sourceStream = request.FileByteStream)
                {
                    CSavedGameSyncCache.Instance.AddRevision(session.UserID, request.GameID, request.FileName, request.ComputerName, request.Fingerprint, request.DateModified, sourceStream, session.EffectivePremiumStatus);
                }
            }
            catch (IOException exc)
            {
                if (exc.InnerException != null && exc.InnerException.InnerException is System.Xml.XmlException)
                {
                    Logger.Log("AddRevision - XmlException Reading Steam! Details: {0}", ELogLevel.Debug, exc.GetExceptionDetails());
                }
                else
                {
                    throw;
                }
            }
            catch (Exception exc)
            {
                Logger.Log("AddRevision - Unhandled Exception! Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
            }
        }        
        #endregion
    }
}
