﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;
using System.Threading;
using System.Data;
using System.Data.SqlClient;

namespace Curse.ClientService
{
    public class CDownloadTracker
    {
        private static readonly int _updateThreadInterval = 1000 * 60 * 5; // 5 mins by default.
        private static string _connectionString = null;
        private static Thread _writeToDatabaseThread = null;

        private static Dictionary<int, int> _fileDownloads = null;
        private static readonly object _fileDownloadsSyncRoot = new object();

        public static void Initialize()
        {
            _connectionString = ConfigurationManager.ConnectionStrings["RoamingDBRadon"].ConnectionString;
            _fileDownloads = new Dictionary<int, int>();
            _writeToDatabaseThread = new Thread(WriteToDatabaseThread) { IsBackground = true };
            _writeToDatabaseThread.Start();
        }

        public static void LogFileDownload(int fileID)
        {
            lock (_fileDownloadsSyncRoot)
            {
                if (_fileDownloads.ContainsKey(fileID))
                {
                    _fileDownloads[fileID] += 1;
                }
                else
                {
                    _fileDownloads.Add(fileID, 1);
                }
            }
        }

        public static void WriteToDatabaseThread()
        {
            Boolean aborted = false;
            while (!aborted)
            {
                //Every minute for now:            
                Thread.Sleep(_updateThreadInterval);
                try
                {
                    WriteToDatabase();
                    Logger.Log(ELogLevel.Info, null, "AddOnDownloadTracker: Project download statistics saved.");
                }
                catch (ThreadAbortException)
                {
                    aborted = true;
                }
                catch (Exception ex)
                {
                    Logger.Log(ELogLevel.Error,
                           null,
                           "AddOnDownloadTracker Error: " + ex.Message + Environment.NewLine + "Stack:" + ex.StackTrace);
                }
            }

        }

        private static void WriteToDatabase()
        {

            // File Downloads
            Dictionary<int, int> fileDownloads = null;
            lock (_fileDownloadsSyncRoot)
            {
                fileDownloads = new Dictionary<int, int>(_fileDownloads);
                _fileDownloads.Clear();
            }

            Dictionary<int, int> projectDownloads = new Dictionary<int,int>();
            foreach (KeyValuePair<int, int> kvp in fileDownloads)
            {
                int projectID = CFileCache.Instance.GetAddonIDByFileID(kvp.Key);
                if (projectID > 0)
                {
                    projectDownloads[projectID] = kvp.Value;
                }
                
            }

            SaveProjectDownloads(projectDownloads);
            //TODO: Revisit this
            //SaveFileDownloads(fileDownloads);           
        }

        private static void SaveProjectDownloads(Dictionary<int, int> projectDownloads)
        {
            if (projectDownloads.Count == 0)
            {
                return;
            }

            DataTable fileDownloadsTable = new DataTable();
            fileDownloadsTable.Columns.Add("ID", typeof(int));
            fileDownloadsTable.Columns.Add("DownloadCount", typeof(int));
            fileDownloadsTable.BeginLoadData();
            foreach (KeyValuePair<int, int> kvp in projectDownloads)
            {
                DataRow row = fileDownloadsTable.NewRow();
                row["ID"] = kvp.Key;
                row["DownloadCount"] = kvp.Value;
                fileDownloadsTable.Rows.Add(row);
            }

            using (SqlConnection conn = new SqlConnection(_connectionString))
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "CREATE TABLE [#tmp]([ID] [int] NOT NULL, [DownloadCount] [int] NOT NULL)";

                try 
                {
                    conn.Open();
                }
                catch (Exception)
                {
                    Logger.Log(ELogLevel.Info, "localhost", "Unable to establish connection to database:" + DateTime.Now.ToString());
                    return;
                }

                cmd.ExecuteNonQuery();
                using (SqlBulkCopy bulk = new SqlBulkCopy(conn, SqlBulkCopyOptions.TableLock, null)) {
                    bulk.DestinationTableName = "#tmp";
                    bulk.WriteToServer(fileDownloadsTable);
                }

                using (SqlTransaction trans = conn.BeginTransaction()) {
                    cmd.Transaction = trans;
                    
                    //First update the download count
                    cmd.CommandText = "UPDATE [a] SET [a].[DownloadCount] = [a].[DownloadCount] + [b].[DownloadCount] FROM dbo.Project AS [a] INNER JOIN [#tmp] AS [b] ON [b].[ID] = [a].[ID]";
                    cmd.ExecuteNonQuery();

                    //Now update the daily count
                    cmd.CommandText = "UPDATE [a] SET [a].[DownloadCount] = [a].[DownloadCount] + [b].[DownloadCount] FROM dbo.ProjectDailyDownloadCount AS [a] INNER JOIN [#tmp] AS [b] ON [b].[ID] = [a].[ID]";
                    cmd.ExecuteNonQuery();

                    trans.Commit();
                }//using transaction
            }
        }

        private static void SaveFileDownloads(Dictionary<int, int> fileDownloads)
        {

            if (fileDownloads.Count == 0)
            {
                return;
            }

            DataTable fileDownloadsTable = new DataTable();
            fileDownloadsTable.Columns.Add("id", typeof(int));
            fileDownloadsTable.Columns.Add("download_count", typeof(int));
            fileDownloadsTable.BeginLoadData();

            foreach (KeyValuePair<int, int> kvp in fileDownloads)
            {
                DataRow row = fileDownloadsTable.NewRow();
                row["id"] = kvp.Key;
                row["download_count"] = kvp.Value;
                fileDownloadsTable.Rows.Add(row);
            }

            using (SqlConnection conn = new SqlConnection(_connectionString))
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "create table #tmp (id int, download_count int);";

                conn.Open();
                cmd.ExecuteNonQuery();
                using (SqlBulkCopy bulk = new SqlBulkCopy(conn, SqlBulkCopyOptions.TableLock, null))
                {
                    bulk.DestinationTableName = "#tmp";
                    bulk.WriteToServer(fileDownloadsTable);
                }
                cmd.CommandText = "update curse_ProjectFile set Downloads = Downloads + download_count" +
                    " from curse_ProjectFile, #tmp where curse_ProjectFile.FileId = #tmp.id;";

                cmd.ExecuteNonQuery();
            }
        }

    }
}
