﻿using System;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;
using System.IO;

namespace Curse.ClientService {
    class RequestLimitingBindingElement : MessageEncodingBindingElement {
        long _maxRequestSize;
        MessageEncodingBindingElement _bindingElement;

        public RequestLimitingBindingElement(MessageEncodingBindingElement bindingElement, long maxRequestSize) {
            _maxRequestSize = maxRequestSize;
            _bindingElement = bindingElement;
        }

        public override MessageVersion MessageVersion {
            get { return _bindingElement.MessageVersion; }
            set { _bindingElement.MessageVersion = value; }
        }
        public override MessageEncoderFactory CreateMessageEncoderFactory() {
            return new RequestLimitingEncoderFactory(_bindingElement.CreateMessageEncoderFactory(), _maxRequestSize);
        }
        public override BindingElement Clone() {
            return new RequestLimitingBindingElement((MessageEncodingBindingElement)_bindingElement.Clone(), _maxRequestSize);
        }
        public override IChannelListener<TChannel> BuildChannelListener<TChannel>(BindingContext context) {
            context.BindingParameters.Add(this);
            return context.BuildInnerChannelListener<TChannel>();
        }
        static Binding GetBinding(bool server) {
            BasicHttpBinding result = new BasicHttpBinding();
            if (server) {
                CustomBinding custom = new CustomBinding(result);
                for (int i = 0; i < custom.Elements.Count; i++) {
                    MessageEncodingBindingElement mebe = custom.Elements[i] as MessageEncodingBindingElement;
                    if (mebe != null) {
                        custom.Elements[i] = new RequestLimitingBindingElement(mebe, 1000);
                        break;
                    }
                }

                return custom;
            }
            else {
                return result;
            }
        }

        class RequestLimitingEncoderFactory : MessageEncoderFactory {
            long _maxRequestSize;
            MessageEncoderFactory _factory;

            public override MessageVersion MessageVersion {
                get { return _factory.MessageVersion; }
            }
            public RequestLimitingEncoderFactory(MessageEncoderFactory facroty, long maxRequestSize) {
                _maxRequestSize = maxRequestSize;
                _factory = facroty;
            }
            public override MessageEncoder Encoder {
                get { 
                    return new RequestLimitingEncoder(_factory.Encoder, _maxRequestSize); 
                }
            }
        }
        class RequestLimitingEncoder : MessageEncoder {
            long _maxRequestSize;
            MessageEncoder _encoder;

            public RequestLimitingEncoder(MessageEncoder encoder, long maxRequestSize) {
                _maxRequestSize = maxRequestSize;
                _encoder = encoder;
            }

            public override string ContentType {
                get { return _encoder.ContentType; }
            }

            public override string MediaType {
                get { return _encoder.MediaType; }
            }

            public override MessageVersion MessageVersion {
                get { return _encoder.MessageVersion; }
            }

            public override bool IsContentTypeSupported(string contentType) {
                return _encoder.IsContentTypeSupported(contentType);
            }

            public override Message ReadMessage(ArraySegment<byte> buffer, BufferManager bufferManager, string contentType) {
                return _encoder.ReadMessage(buffer, bufferManager, contentType);
            }

            public override Message ReadMessage(Stream stream, int maxSizeOfHeaders, string contentType) {
                return _encoder.ReadMessage(stream, maxSizeOfHeaders, contentType);
            }

            public override ArraySegment<byte> WriteMessage(Message message, int maxMessageSize, BufferManager bufferManager, int messageOffset) {
                ArraySegment<byte> result = _encoder.WriteMessage(message, maxMessageSize, bufferManager, messageOffset);
                int messageSize = result.Offset + result.Count;
                Console.WriteLine("Return message size: {0}", messageSize);
                if (messageSize > _maxRequestSize) {
                    // This is a quick/dirty solution. This will simply cause the server to abort the socket,
                    // and the client will receive a generic "socket abort exception"
                    //
                    // Another solution would be for this encoder to produce a fault or some
                    // response which the client can understand.
                    Console.WriteLine("Message size ({0}) is greater than MaxSentMessageSize ({1})", messageSize, _maxRequestSize);
                    throw new InvalidOperationException("MaxSentMessageSize exceeded");
                }

                return result;
            }

            public override void WriteMessage(Message message, Stream stream) {
                // To implement this, wrap the stream with a "CountingStream", which would throw if
                // its size grew past MaxSentMessageSize.
                throw new NotImplementedException();
            }
        }
    }
}