﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using Curse.CommunityTracker.Models;
using System.Configuration;
using System.IO;
using Curse.CommunityTracker.Extensions;
using Curse.CommunityTracker.Caching;
using System.Threading;
using System.Net;

namespace Curse.CommunityTracker
{
    public class CommunityTracker : ICommunityTracker
    {
        private static object _startLock = new object();

        static CommunityTracker()
        {
            
            lock (_startLock)
            {
                try
                {

                    Logger.Log("Initializing Data Source Cache...", ELogLevel.Info);
                    ForumDataSourceCache.Initialize();

                    Logger.Log("Initializing Author Cache...", ELogLevel.Info);
                    CAuthorCache.Initialize();

                    Logger.Log("Initializing Forum Cache...", ELogLevel.Info);
                    CForumCache.Initialize();

                    Logger.Log("Initializing Thread Cache...", ELogLevel.Info);
                    CForumThreadCache.Initialize();

                    Logger.Log("Initializing Post Cache...", ELogLevel.Info);
                    CForumThreadPostCache.Initialize();

                    Logger.Log("Service Started", ELogLevel.Info);
                }
                catch (Exception ex)
                {
                    Logger.Log("Could not start CommunityTracker Service! Details: {0}", ELogLevel.Error, ex.GetExceptionDetails());
                    throw;
                }
            }
        }

        public ForumDataSource[] GetAllDataSources()
        {
            return ForumDataSourceCache.Instance.GetAllForumDataSources().ToArray();
        }

        public ForumDataSource[] GetDataSourceByGameId(int id)
        {
            //int idValue = ValidateInt(id);
            var sources = ForumDataSourceCache.Instance.GetDataSourcesByGameId(id);
            if (sources != null)
            {
                return sources.ToArray();
            }

            return new ForumDataSource[0];
        }

        public ForumDataSource[] GetDataSourceByLanguage(int gameId, string language)
        {
            var sources = ForumDataSourceCache.Instance.GetDataSourcesByLanguage(gameId, language);
            if (sources != null)
            {
                return sources.ToArray();
            }

            return new ForumDataSource[0];
        }

        public CForum[] GetForumsBySourceId(int id)
        {
            var forums = CForumCache.Instance.GetForumsBySourceId(id);
            if (forums != null)
            {
                return forums.ToArray();
            }

            return new CForum[0];
        }

        public CForumThread[] GetThreadsByForumId(int id, long since)
        {
            var threads = CForumThreadCache.Instance.GetThreadsByForumId(id, since.ToDateTime());
            if (threads != null)
            {
                return threads.ToArray();
            }

            return new CForumThread[0];
        }

        public CForumThreadPost[] GetPostsByThreadId(int id, long since)
        {
            var posts = CForumThreadPostCache.Instance.GetPostsByThreadId(id, since.ToDateTime());
            if (posts != null)
            {
                return posts.ToArray();
            }

            return new CForumThreadPost[0];
        }

        public UpdatedThread[] GetAllActivitySince(int dataSourceId, long since)
        {
            return GetAllActivitySince(new int[] { dataSourceId }, since);
        }

        public UpdatedThread[] GetAllActivitySince(int[] ids, long since)
        {
            var updatedThreads = CForumThreadCache.Instance.GetRecentThreadActivity(ids, since.ToDateTime());
            if (updatedThreads != null)
            {
                return updatedThreads.ToArray();
            }

            return new UpdatedThread[0];
        }

        public DataSourceActivity[] GetAllActivitySinceFull(int[] dataSourceIds, long since)
        {
            IEnumerable<DataSourceActivity> dataSourceActivity = ForumDataSourceCache.Instance.GetAllRecentActivity(dataSourceIds, since.ToDateTime());

            if (dataSourceActivity != null)
            {
                return dataSourceActivity.ToArray();
            }

            return new DataSourceActivity[0];
        }

        public CAuthor[] GetAuthorsByDataSourceId(int id, long since)
        {
            return CAuthorCache.Instance.GetAuthorsByDataSourceID(id, since.ToDateTime()).ToArray();
        }
    }
}
