﻿using System;
using Curse.CommunityTracker.Models;
using System.Data.SqlClient;
using Curse.CommunityTracker.Caching;

namespace Curse.CommunityTracker.Extensions {
    public static class CForumThreadExtension 
    {
        
        public static void SetFromDataReader(this CForumThread thread, SqlDataReader reader)
        {
            thread.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            thread.ForumID = reader.GetInt32(reader.GetOrdinal("CommunityForumID"));
            thread.AuthorID = reader.GetInt32(reader.GetOrdinal("CommunityAuthorID"));
            thread.Author = reader.GetString(reader.GetOrdinal("AuthorName"));
            thread.Title = reader.GetString(reader.GetOrdinal("Title"));
            thread.Url = reader.GetString(reader.GetOrdinal("Url"));
            thread.Pages = reader.GetInt32(reader.GetOrdinal("Pages"));
            thread.Replies = reader.GetInt32(reader.GetOrdinal("Replies"));
            thread.Views = reader.GetInt32(reader.GetOrdinal("Views"));
            thread.LastRunTimeUtc = reader.GetDateTime(reader.GetOrdinal("LastRunTimeUTC"));
            thread.DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"));
            thread.DateModified = reader.GetDateTime(reader.GetOrdinal("DateModified"));
            thread.LatestPostDate = reader.GetNullbaleValue<DateTime>("LatestPostDate");

            thread.Slug = reader.GetString(reader.GetOrdinal("Slug"));
            thread.TrackedReplies = reader.GetNullbaleValue<int>("TrackedReplies");
            thread.LatestPostDate = reader.GetNullbaleValue<DateTime>("LatestTrackedPostDate");
            
            var author = CAuthorCache.Instance.GetAuthorByID(thread.AuthorID);
            if (author != null) {
                thread.CommunityAuthor = author;
            }
        }
    }
}