﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.CommunityTracker.Extensions {
    public static class ExceptionExtensions {
        public static string GetExceptionDetails(this Exception ex) {
            string exceptionMessage = string.Empty;
            while (ex != null) {
                exceptionMessage += "Type: " + ex.GetType().ToString()
                    + Environment.NewLine + Environment.NewLine
                    + "Message: " + ex.Message
                    + Environment.NewLine + Environment.NewLine
                    + "Stack Trace: " + ex.StackTrace
                    + Environment.NewLine + Environment.NewLine;

                ex = ex.InnerException;
            }
            return exceptionMessage;
        }
    }
}
