﻿using System;
using Curse.CommunityTracker.Models;
using System.Data.SqlClient;

namespace Curse.CommunityTracker.Extensions {
    public static class ForumDataSourceExtension {
        public static void SetFromDataReader(this ForumDataSource source,  SqlDataReader reader) {
            source.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            source.Name = reader.GetString(reader.GetOrdinal("Name"));
            source.GameID = reader.GetInt32(reader.GetOrdinal("GameID"));
            source.Language = reader.GetString(reader.GetOrdinal("Language"));
            source.LastRunTimeUtc = reader.GetNullbaleValue<DateTime>("LastRunTimeUTC");
            source.BaseUrl = reader.GetString(reader.GetOrdinal("BaseUrl"));
            source.DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"));
            source.DateModified = reader.GetDateTime(reader.GetOrdinal("DateModified"));
            source.Status = (ForumDataSourceStatus)reader.GetByte(reader.GetOrdinal("Status"));
            source.TimeZoneID = reader.GetInt32(reader.GetOrdinal("TimeZoneID"));
            source.Type = (ForumDataSourceType)reader.GetByte(reader.GetOrdinal("Type"));
            source.PostConfigurationID = reader.GetNullbaleValue<int>("PostConfigurationID");
        }
    }
}