﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using Curse.CommunityTracker.Models;

namespace Curse.CommunityTracker {
    [ServiceContract]
    public interface ICommunityTracker 
    {        

        [OperationContract]
        [WebGet]
        ForumDataSource[] GetAllDataSources();

        [OperationContract]
        [WebGet]
        ForumDataSource[] GetDataSourceByGameId(int id);

        [OperationContract]
        [WebGet]
        ForumDataSource[] GetDataSourceByLanguage(int gameId, string language);

        [OperationContract]
        [WebGet]
        CForum[] GetForumsBySourceId(int id);

        [OperationContract]
        [WebGet]
        CForumThread[] GetThreadsByForumId(int id, long since);        

        [OperationContract]
        [WebGet]
        CForumThreadPost[] GetPostsByThreadId(int id, long since);

        [OperationContract(Name="GetAllSourceActivitySince")]
        [WebGet]
        UpdatedThread[] GetAllActivitySince(int dataSourceId, long since);
        
        [OperationContract(Name="GetAllActivitySince")]
        [WebGet]
        UpdatedThread[] GetAllActivitySince(int[] dataSourceIds, long since);

        [OperationContract(Name = "GetAllActivitySinceFull")]
        [WebGet]
        DataSourceActivity[] GetAllActivitySinceFull(int[] dataSourceIds, long since);

        [OperationContract]
        [WebGet]
        CAuthor[] GetAuthorsByDataSourceId(int id, long since);
    }
}
