﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;

namespace Curse.CommunityTracker.Models 
{
    public enum AuthorType 
    {
        Unknown = 1,
        NormalUser = 2,
        Moderator = 3,
        Mvp = 4,
        Developer = 5,
        Community = 6,
        CustomerService = 7
    }
    
    [DataContract(Name="author")]
    public class CAuthor 
    {
        [DataMember(Name = "id")]
        public int ID { get; set; }

        [DataMember(Name = "dataSourceId")]
        public int DataSourceID { get; set; }

        [DataMember(Name = "name")]
        public string Name { get; set; }

        [DataMember(Name = "avatarUrl")]
        public string AvatarUrl { get; set; }

        [DataMember(Name = "type")]
        public AuthorType Type { get; set; }

        [DataMember(Name = "title")]
        public string Title { get; set; }
    }
}