﻿using System;
using System.Runtime.Serialization;

namespace Curse.CommunityTracker.Models {
    [DataContract(Name = "CForumThread")]
    public class CForumThread {
        [DataMember(Name = "id")]
        public int ID { get; set; }
        
        [DataMember(Name = "forumId")]
        public int ForumID { get; set; }

        [DataMember(Name = "authorID")]
        public int AuthorID { get; set; }

        [DataMember(Name = "author")]
        public string Author { get; set; }

        [DataMember(Name = "communityAuthor")]
        public CAuthor CommunityAuthor{ get; set; }

        [DataMember(Name = "title")]
        public string Title { get; set; }

        [DataMember(Name = "url")]
        public string Url { get; set; }

        [DataMember(Name = "slug")]
        public string Slug { get; set; }

        [DataMember(Name = "pages")]
        public int Pages { get; set; }

        [DataMember(Name = "replies")]
        public int Replies { get; set; }

        [DataMember(Name = "trackedReplies")]
        public int TrackedReplies { get; set; }
        
        [DataMember(Name = "views")]
        public int Views { get; set; }
        
        [DataMember(Name = "lastRunTimeUtc")]
        public DateTime LastRunTimeUtc { get; set; }

        [DataMember(Name = "dateCreated")]
        public DateTime DateCreated { get; set; }

        [DataMember(Name = "dateModified")]
        public DateTime DateModified { get; set; }

        [DataMember(Name = "latestPostDate")]
        public DateTime LatestPostDate { get; set; }               

    }
}