﻿using System;
using System.Runtime.Serialization;
using System.Data.SqlClient;

namespace Curse.CommunityTracker.Models{
    public enum ForumDataSourceStatus {
        Normal=1,
        Inactive
    }

    public enum ForumDataSourceType {
        Forum=1,
        Blog
    }
    
    [DataContract(Name = "ForumDataSource")]
    public class ForumDataSource {
        [DataMember(Name = "id")]
        public int ID { get; set; }

        [DataMember(Name = "name")]
        public string Name { get; set; }

        [DataMember(Name = "gameId")]
        public int GameID { get; set; }

        [DataMember(Name = "languageId")]
        public string Language { get; set; }

        [DataMember(Name = "lastRunTime")]
        public DateTime LastRunTimeUtc { get; set; }

        [DataMember(Name = "baseUrl")]
        public string BaseUrl { get; set; }

        [DataMember(Name = "dateCreated")]
        public DateTime DateCreated { get; set; }

        [DataMember(Name = "dateModified")]
        public DateTime DateModified { get; set; }

        [DataMember(Name = "status")]
        public ForumDataSourceStatus Status { get; set; }

        [DataMember(Name = "timeZoneId")]
        public int TimeZoneID { get; set; }

        [DataMember(Name = "type")]
        public ForumDataSourceType Type { get; set; }

        [DataMember(Name = "postConfigurationId")]
        public int PostConfigurationID { get; set; }
    }
}