﻿using System;
using System.ServiceModel;
using Curse.ClientService.Models;
using System.IO;
using Curse.CloudServices.Authentication;
using Curse.Logging;

namespace Curse.AddOnService
{
    [ServiceBehavior(Name = "CClientBackupService",
        Namespace = "http://addonservice.curse.com/",
        AddressFilterMode = AddressFilterMode.Any,
        ConcurrencyMode = ConcurrencyMode.Multiple)]
    public class AddonSyncFileService : IAddOnSyncFileService
    {
        #region UserBackups

        public void SaveUserBackup(UserBackupMessage request)
        {
            var session = AuthenticationContext.Current;

            try
            {
                using (var sourceStream = request.FileByteStream)
                {
                    AddOnSyncCache.Instance.SaveUserBackup(session.UserID, request.InstanceID, request.Fingerprint, request.ScreenWidth, request.ScreenHeight, sourceStream);
                    sourceStream.Close();
                }
            }
            catch (IOException exc)
            {
                if (exc.InnerException != null && exc.InnerException.InnerException is System.Xml.XmlException)
                {
                    Logger.Warn(exc, "SaveUserBackup - XmlException Reading Steam!");
                }
                else
                {
                    throw;
                }
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "SaveUserBackup - Unhandled Exception!");
            }
        }

        #endregion

        #region Saved Game Sync

        public void SyncSavedGame(SavedGameSyncMessage request)
        {
            var session = AuthenticationContext.Current;

            try
            {
                var restriction = SavedGameSyncCache.Instance.RestrictionLevel;
                switch (restriction)
                {
                    case ESavedGameRestrictionLevel.Disabled:
                        return;
                    case ESavedGameRestrictionLevel.PremiumOnly:
                        if (!session.HasPremium)
                        {
                            return;
                        }
                        break;
                }

                using (var sourceStream = request.FileByteStream)
                {
                    SavedGameSyncCache.Instance.SyncSavedGame(session.UserID, request.GameID, request.FileName, request.ComputerName, request.Fingerprint, request.DateModified, sourceStream, session.HasPremium);
                }
            }
            catch (IOException ex)
            {
                if (ex.InnerException != null && ex.InnerException.InnerException is System.Xml.XmlException)
                {
                    Logger.Debug(ex, "SyncSavedGame - XmlException Reading Steam!");
                }
                else
                {
                    throw;
                }
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "SyncSavedGame - Unhandled Exception!");
            }
        }

        public void AddRevision(SavedGameSyncMessage request)
        {
            var session = AuthenticationContext.Current;

            try
            {
                var restriction = SavedGameSyncCache.Instance.RestrictionLevel;
                switch (restriction)
                {
                    case ESavedGameRestrictionLevel.Disabled:
                        return;
                    case ESavedGameRestrictionLevel.PremiumOnly:
                        if (!session.HasPremium)
                        {
                            return;
                        }
                        break;
                }

                using (var sourceStream = request.FileByteStream)
                {
                    SavedGameSyncCache.Instance.AddRevision(session.UserID, request.GameID, request.FileName, request.ComputerName, request.Fingerprint, request.DateModified, sourceStream, session.HasPremium);
                }
            }
            catch (IOException ex)
            {
                if (ex.InnerException != null && ex.InnerException.InnerException is System.Xml.XmlException)
                {
                    Logger.Debug(ex, "AddRevision - XmlException Reading Steam!");
                }
                else
                {
                    throw;
                }
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "AddRevision - Unhandled Exception!");
            }
        }

        #endregion
    }
}
