﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Data.SqlClient;
using Curse.AddOns;
using System.Data;
using Curse.Logging;

namespace Curse.AddOnService
{
    public class AttachmentCache
    {
        private static readonly AttachmentCache _instance;

        public static AttachmentCache Instance
        {
            get
            {
                return _instance;
            }
        }

        static AttachmentCache()
        {
            _instance = new AttachmentCache();
        }

        public Dictionary<int, List<AddOnAttachment>> GetAttachmentCache(SqlConnection conn, DateTime changeDate)
        {

            Dictionary<int, List<AddOnAttachment>> attachmentCache = new Dictionary<int, List<AddOnAttachment>>();                    

            using (SqlCommand attachmentCommand = new SqlCommand("curseService_GetAllAttachmentsV2", conn))
            {
                attachmentCommand.CommandType = CommandType.StoredProcedure;
                attachmentCommand.Parameters.Add(new SqlParameter("@LastUpdated", SqlDbType.DateTime));
                attachmentCommand.Parameters["@LastUpdated"].Value = changeDate;
                attachmentCommand.CommandTimeout = 300;

                using (SqlDataReader attachmentReader = attachmentCommand.ExecuteReader())
                {
                    while (attachmentReader.Read())
                    {
                        int id = 0;
                        try
                        {
                            id = attachmentReader.GetInt32(attachmentReader.GetOrdinal("addon_attachment_id"));
                            int projectID = attachmentReader.GetInt32(attachmentReader.GetOrdinal("addon_attachment_project_id"));

                            string description = attachmentReader.GetString(attachmentReader.GetOrdinal("addon_attachment_description"));
                            string title = attachmentReader.GetString(attachmentReader.GetOrdinal("addon_attachment_title"));
                            bool isDefault = attachmentReader[attachmentReader.GetOrdinal("addon_attachment_default")] as int? == 1;

                            string thumbnailUrl = attachmentReader[attachmentReader.GetOrdinal("addon_attachment_thumbnail_url")] == DBNull.Value ? "" 
                                : attachmentReader.GetString(attachmentReader.GetOrdinal("addon_attachment_thumbnail_url"));
                            
                            string url =  attachmentReader[attachmentReader.GetOrdinal("addon_attachment_url")] == DBNull.Value ? "" 
                                : attachmentReader.GetString(attachmentReader.GetOrdinal("addon_attachment_url"));

                            if (!attachmentCache.ContainsKey(projectID))
                            {
                                attachmentCache.Add(projectID, new List<AddOnAttachment>());
                            }

                            AddOnAttachment attachment = new AddOnAttachment();

                            attachment.ID = id;
                            attachment.ProjectID = projectID;
                            attachment.Description = description;
                            attachment.IsDefault = isDefault;
                            attachment.Title = title;
                            attachment.ThumbnailUrl = thumbnailUrl;
                            attachment.Url = url;

                            attachmentCache[projectID].Add(attachment);
                        }
                        catch (Exception ex)
                        {
                            Logger.Error(ex, "Unable to create attachment record for attachment ID: " + id);
                        }
                    }
                }
            }
            return attachmentCache;
        }
    }
}
