﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.SqlClient;
using Curse.AddOns;
using System.Data;
using Curse.AddOnService.Extensions;

namespace Curse.AddOnService
{
    public class AuthorCache
    {
        private static readonly AuthorCache _instance;

        public static AuthorCache Instance
        {
            get
            {
                return _instance;
            }
        }

        static AuthorCache()
        {
            _instance = new AuthorCache();
        }

        

        public Dictionary<int, List<AddOnAuthor>> GetAuthorCache(SqlConnection conn, DateTime changeDate)
        {
            Dictionary<int, List<AddOnAuthor>> authorCache = new Dictionary<int, List<AddOnAuthor>>();                    

            using (SqlCommand authorCommand = new SqlCommand("curseService_GetAllAuthors", conn))
            {
                authorCommand.CommandType = CommandType.StoredProcedure;
                authorCommand.Parameters.Add(new SqlParameter("@LastUpdated", SqlDbType.DateTime));
                authorCommand.Parameters["@LastUpdated"].Value = changeDate;
                authorCommand.CommandTimeout = 300;

                using (SqlDataReader authorReader = authorCommand.ExecuteReader())
                {
                    while (authorReader.Read())
                    {
                        int projectID = authorReader.GetInt32(0);
                        string username = authorReader.GetString(1);

                        if (!authorCache.ContainsKey(projectID))
                        {
                            authorCache.Add(projectID, new List<AddOnAuthor>());
                        }
                        AddOnAuthor author = new AddOnAuthor();
                        author.Name = username;
                        author.Url = author.GetAuthorUrl(username);
                        authorCache[projectID].Add(author);
                    }
                }
            }
            return authorCache;
        }
        
    }
}
